/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.markers.impl;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.excalibur.logger.LoggerManager;

/**
 * <code>LogEnabledMarkerImpl</code> class, implements the standard
 * avalon <code>LogEnabled</code> interface.
 *
 * @author <a href="mailto:crafterm@apache.org">Marcus Crafter</a>
 * @version 1.0
 */
public class LogEnabledMarkerImpl extends AbstractMarker
{
	/**
	 * <code>create</code> method, enables logging on the given
	 * component
	 *
	 * @param component a <code>Component</code> instance
	 * @param context a <code>Context</code> instance
	 * @exception Exception if an error occurs
	 */
	public void create(Component component, Context context)
		throws Exception
	{
		final Configuration config = (Configuration) context.get(COMPONENT_CONFIGURATION);
		final String logger = config.getAttribute("logger", null);

		final LoggerManager logManager = (LoggerManager) context.get(LOGGER_MANAGER);
		final LogEnabled logEnabled = (LogEnabled) component;

		if (null == logger)
			logEnabled.enableLogging(logManager.getDefaultLogger());
		else
			logEnabled.enableLogging(logManager.getLoggerForCategory(logger));
	}
}
