/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.util;

import org.apache.excalibur.fortress.ContainerManagerConstants;

/**
 * Provides constants used to access the Context object for containers.
 *
 * @author <a href="mailto:leo.sutic@inspireinfrastructure.com">Leo Sutic</a>
 * @version CVS $Revision: 1.6 $ $Date: 2002/04/13 01:39:57 $
 */
public interface ContextManagerConstants extends ContainerManagerConstants
{
    String LOG_CATEGORY = "container.logcategory";

    String LOGGER_MANAGER_CONFIGURATION = "container.logManager.config";
    String LOGGER_MANAGER_CONFIGURATION_URI = "container.logManager.config.uri";

    String INSTRUMENT_MANAGER_NAME = "container.instrumentManager";
    String INSTRUMENT_MANAGER_CONFIGURATION = "container.instrumentManager.config";
    String INSTRUMENT_MANAGER_CONFIGURATION_URI = "container.instrumentManager.config.uri";

    String ROLE_MANAGER_CONFIGURATION = "container.roleManager.config";
    String ROLE_MANAGER_CONFIGURATION_URI = "container.roleManager.config.uri";

    String CONFIGURATION_URI = "container.configuration.uri";

    String COMPONENT_MANAGER_CLASS = "container.componentManager.config";
    String COMPONENT_MANAGER_CONFIGURATION = "container.componentManager.config";
    String COMPONENT_MANAGER_PARENT = "container.componentManager.parent";
    String COMPONENT_MANAGER_CONFIGURATION_URI = "container.componentManager.config.uri";

    String MARKER_MANAGER_CONFIGURATION_URI = "container.markerManager.config.uri";
    String MARKER_MANAGER_CONFIGURATION = "container.markerManager.config";
}
