/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included  with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.util;

import java.util.Collections;
import java.util.HashMap;

/**
 * The Excalibur Role Manager is used for Excalibur Role Mappings.  All of the
 * information is hard-coded.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @author <a href="mailto:proyal@apache.org">Peter Royal</a>
 * @version CVS $Revision: 1.11 $ $Date: 2002/06/04 16:53:37 $
 * @since 4.1
 */
public class ExcaliburRoleManager
    extends AbstractRoleManager
{
    /**
     * Default constructor--this RoleManager has no parent.
     */
    public ExcaliburRoleManager()
    {
        this( null );
    }

    /**
     * Alternate constructor--this RoleManager has the specified
     * parent.
     *
     * @param parent  The parent <code>RoleManager</code>.
     */
    public ExcaliburRoleManager( RoleManager parent )
    {
        this( parent, Thread.currentThread().getContextClassLoader() );
    }

    /**
     * Alternate constructor--this RoleManager has the specified
     * parent and a classloader.
     *
     * @param parent  The parent <code>RoleManager</code>.
     */
    public ExcaliburRoleManager( RoleManager parent, ClassLoader loader )
    {
        super( parent, loader );

        HashMap shorts = new HashMap( 10 );
        HashMap classes = new HashMap( 10 );
        HashMap handlers = new HashMap( 10 );

        /* Set up Cache relations */
        setup( shorts, classes, handlers, "cache",
               "org.apache.excalibur.cache.Cache",
               "org.apache.excalibur.cache.impl.DefaultCache",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "lru-cache",
               "org.apache.excalibur.cache.Cache",
               "org.apache.excalibur.cache.impl.LRUCache",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );

        /* Set up DataSource relations */
        setup( shorts, classes, handlers, "jdbc-datasource",
               "org.apache.avalon.excalibur.datasource.DataSourceComponent",
               "org.apache.avalon.excalibur.datasource.JdbcDataSource",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "j2ee-datasource",
               "org.apache.avalon.excalibur.datasource.DataSourceComponent",
               "org.apache.avalon.excalibur.datasource.J2eeDataSource",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "informix-datasource",
               "org.apache.avalon.excalibur.datasource.DataSourceComponent",
               "org.apache.avalon.excalibur.datasource.InformixDataSource",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );

        /* Set up i18n relations */
        setup( shorts, classes, handlers, "i18n",
               "org.apache.avalon.excalibur.i18n.BundleSelector",
               "org.apache.avalon.excalibur.i18n.BundleSelector",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );

        /* Set up Monitor relations */
        setup( shorts, classes, handlers, "monitor",
               "org.apache.avalon.excalibur.monitor.Monitor",
               "org.apache.avalon.excalibur.monitor.ActiveMonitor",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "passive-monitor",
               "org.apache.avalon.excalibur.monitor.Monitor",
               "org.apache.avalon.excalibur.monitor.PassiveMonitor",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );

        /* Set up XPath relations */
        setup( shorts, classes, handlers, "xalan-xpath",
               "org.apache.avalon.excalibur.xml.xpath.XPathProcessor",
               "org.apache.avalon.excalibur.xml.xpath.XPathProcessorImpl",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "jaxpath",
               "org.apache.avalon.excalibur.xml.xpath.XPathProcessor",
               "org.apache.avalon.excalibur.xml.xpath.JaxenProcessorImpl",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );

        /* Set up SourceResolver relations */
        setup( shorts, classes, handlers, "resolver",
               "org.apache.excalibur.source.SourceResolver",
               "org.apache.excalibur.source.impl.SourceResolverImpl",
               "org.apache.excalibur.fortress.handler.ThreadSafeComponentHandler" );

        /* Set up XML parser relations */
        setup( shorts, classes, handlers, "parser",
               "org.apache.avalon.excalibur.xml.Parser",
               "org.apache.avalon.excalibur.xml.JaxpParser",
               "org.apache.excalibur.fortress.handler.PerThreadComponentHandler" );
        setup( shorts, classes, handlers, "xerces-parser",
               "org.apache.avalon.excalibur.xml.Parser",
               "org.apache.avalon.excalibur.xml.XercesParser",
               "org.apache.excalibur.fortress.handler.FactoryComponentHandler" );

        m_shorthands = Collections.unmodifiableMap( shorts );
        m_classNames = Collections.unmodifiableMap( classes );
        m_handlerNames = Collections.unmodifiableMap( handlers );
    }
}
