/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included  with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.excalibur.fortress.util;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;

/**
 * The OverridableContext allows you to "null" out entries, even if they are
 * in a parent context.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.7 $ $Date: 2002/04/24 18:33:18 $
 * @since 4.1
 */
public final class OverridableContext extends DefaultContext
{
    private final Null m_null = new Null();

    public OverridableContext()
    {
        super();
    }

    public OverridableContext( Context parent )
    {
        super( parent );
    }

    public Object get( Object key )
        throws ContextException
    {
        Object value = super.get( key );

        if( m_null.equals( value ) )
        {
            throw new ContextException( "Could not return value for " + key );
        }

        return value;
    }

    public void put( Object key, Object value )
    {
        super.put( key, ( value == null ) ? new Null() : value );
    }

    private static final class Null
    {
        public boolean equals( Object other )
        {
            return other instanceof Null;
        }

        public int hashcode()
        {
            return 0;
        }

        public String toString()
        {
            return "null";
        }
    }
}
