package org.apache.bcel.proxy;
import java.io.*;
import java.lang.reflect.Method;

import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;

/**
 * Dynamically creates and uses a proxy.
 *
 * @version $Id: Proxy.java,v 1.1.1.1 2001/10/29 20:01:10 jvanzyl Exp $
 * @see org.apache.bcel.util.JavaWrapper
 * @see org.apache.bcel.util.ClassLoader
 * @see Utility
 */
public class Proxy {

    private static int counter = 0;

    /** 
     * Load class and create instance
     */
    private static Object createProxy(String class_name, JavaClass clazz, ClassLoader loader) {
        try {
            //System.out.println("loading class: " + clazz.getClassName());
            Class cl = loader.loadClass(clazz.getClassName());
            return cl.newInstance();
        } catch(Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /** 
     * Create a dynamic proxy.
     */
    public static Object newProxyInstance(ClassLoader loader, Class[] interfaces, InvocationHandler handler) throws Exception {
        String className = "$$BCEL$$Proxy$" + counter++;
        ProxyCreator creator = new ProxyCreator(className, new ClassLoaderRepository(loader), interfaces);
        JavaClass clazz = creator.getJavaClass();

        Method method = loader.getClass().getMethod("addClass",  new Class[] { String.class, String.class });
        method.invoke(null, new Object[] { clazz.getClassName(), Utility.encode(clazz.getBytes(), true) });
        //((ProxyClassLoader) loader).addClass(clazz);

        //TODO: soft reference caching
        Object p = createProxy(className, clazz, loader);
        method = p.getClass().getMethod("setInvocationHandler",  new Class[] { InvocationHandler.class });
        method.invoke(p, new Object[] { handler });
        return p;
    }

}
