package org.apache.bcel.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ClassLoader;

/**
 * @author neeme
 *
 */
public class ProxyClassLoader extends ClassLoader {

    private static Map map = new HashMap();

    public static void addClass(String class_name, String clazz) {
        //System.out.println("putting class with len " + clazz.length() + " under name " + class_name);
        map.put(class_name, clazz);
        //System.out.println("put, map contains " + map.keySet().size() + " key(s)");
    }

  protected JavaClass createClass(String class_name) {
    JavaClass clazz = null;
    try {
      ClassParser parser = new ClassParser(getInputStream(class_name, "foo"), "foo");
      clazz = parser.parse();
    } catch(Throwable e) {
      e.printStackTrace();
      return null;
    }

    // Adapt the class name to the passed value
    ConstantPool cp = clazz.getConstantPool();

    ConstantClass cl = (ConstantClass)cp.getConstant(clazz.getClassNameIndex(),
                             Constants.CONSTANT_Class);
    ConstantUtf8 name = (ConstantUtf8)cp.getConstant(cl.getNameIndex(),
                             Constants.CONSTANT_Utf8);
    name.setBytes(class_name.replace('.', '/'));

    return clazz;
  }


  protected InputStream _getInputStream(String class_name, String file_name) {
    int    index     = class_name.indexOf("$$BCEL$$");
    String source = class_name.substring(index + 8);
    try {
      byte[]      bytes  = Utility.decode(source, true);
      return new ByteArrayInputStream(bytes);
    } catch(Throwable e) {
      e.printStackTrace();
    }
    return null;
  }


    /**
     * @see org.apache.bcel.util.ClassLoader#getInputStream(java.lang.String, java.lang.String)
     */
    protected InputStream getInputStream(String class_name, String file_name) {
        InputStream is = null;
        try {
            String clazz = (String) map.get(class_name);
            //System.out.println("got class " + clazz + " for name " + class_name);
            //System.out.println("get, map contains " + map.keySet().size() + " key(s)");
            if (clazz != null) is = new ByteArrayInputStream(Utility.decode(clazz,true));
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (is != null)
            return is;
        else
            return _getInputStream(class_name, file_name);
            //return super.getInputStream(class_name, file_name);
    }

}
