package org.apache.bcel.proxy.sample;

import java.lang.reflect.Method;

import org.apache.bcel.proxy.InvocationHandler;

/**
 * @author neeme
 *
 */
public class InvocationHandlerSample implements InvocationHandler {

    private Object o;

    /**
     * Constructor for InvocationHandlerSample.
     */
    public InvocationHandlerSample(Object o) {
        this.o = o;
    }

    /**
     * @see org.apache.bcel.proxy.InvocationHandler#invoke(java.lang.Object, java.lang.reflect.Method, java.lang.Object)
     */
    public Object invoke(Object proxy, Method method, Object[] args)
        throws Throwable {
        System.out.println("invoke() start");
        System.out.println("    method: " + method.getName());
        for (int i = 0; i < args.length; i++) {
            System.out.println("    arg: " + args[i]);
        }
        Object r = method.invoke(o, args);
        System.out.println("    return: " + r);
        System.out.println("invoke() end");
        return r;
    }

}
