package org.apache.bcel.proxy.sample;

import org.apache.bcel.proxy.Proxy;

/**
 * @author neeme
 *
 */
public class SampleRunner {

    public void run(ClassLoader loader) throws Exception {
        Class[] interfaces = new Class[] {ProxySampleInterface_ReturnsObject.class, ProxySampleInterface_ReturnsBasic.class};
        InvocationHandlerSample ih = new InvocationHandlerSample(new SampleImpl());
        System.out.println("creating proxy ... ");
        Object p = Proxy.newProxyInstance(loader, interfaces, ih);
        ProxySampleInterface_ReturnsObject ro = (ProxySampleInterface_ReturnsObject) p;
        System.out.println("proxy created. testing...");
        System.out.println("calling getKala(\"mees\")");
        String r_ro = ro.getKala("mees");
        System.out.println("getKala(String) returned: " + r_ro);
        ProxySampleInterface_ReturnsBasic rb = (ProxySampleInterface_ReturnsBasic) p;
        System.out.println();
        System.out.println("calling getKala(11)");
        int r_rb = rb.getKala(11);
        System.out.println("getKala(float) returned: " + r_rb);
    }

}
