
package org.k2d2.framework.serverframework;

import org.k2d2.framework.serverframework.core.ServerCommand;

/**
 * This class implements a variation of the MultiDispatchServer. The DispatchServer
 * supports only one ServerCommand object and hence no chaining. For more details see
 * the documentation for MultiDispatchServer
 * @see org.k2d2.serverframework.MultiDispatchServer
 * @author Karthik Rangaraju
 */
public class DispatchServer extends MultiDispatchServer
{
	private boolean mCommandAdded = false;
	
	/**
	 * This method constructs a new DispatchServer with a specified size for its
	 * in-queue and out-queue
	 * @param pQueueSize - the size of the server's in-queue and out-queue as an int
	 */
	public DispatchServer(int pQueueSize)
	{
		super(pQueueSize);
	}
	
	/**
	 * This method sets the DispatchServer's ServerCommand. Unlike MultiDispatchServer
	 * the DispatchServer only supports a single ServerCommand. Chaining of
	 * ServerCommands is not supported.
	 * @see org.k2d2.serverframework.MultiDispatchServer
	 */
	public void addServerCommand(ServerCommand pCommand)
	{
		if (mCommandAdded == false)
		{
			mCommandAdded = true;
			super.addServerCommand(pCommand);
		}
	}
}

