
package org.k2d2.framework.serverframework.pool;

/**
 * This interface defines the pooled resource wrapper. Access to a pooled resource
 * is obtained via this interface. PooledResources are managed via the PoolManager.
 *
 * @author Karthik Rangaraju
 * @see PoolManager
 */
public interface PooledResource
{
	/**
	 * This method returns the resource that this wrapper manages. It is the
	 * application's responsibility to cast the returned Object to the
	 * appropriate class. References to the managed resource should not be
	 * stored by the application.
	 * @return Object - reference to object being managed
	 */
	public Object get();
	
	/**
	 * This method signals the application's intent to return the resource to
	 * the pool managed by the PoolManager. The reference to this wrapper
	 * should not be used by the application after this method call.
	 * @see PoolManager
	 */
	public void release();
}

