
package org.k2d2.framework.serverframework.util;

import org.k2d2.framework.serverframework.core.ServerCommand;

/**
 * This class implements a simple ServerCommand to implement the Command pattern. The
 * class expects objects in its in-queue that implement the CommandTask interface and calls
 * the execute() method on them. Enqueuing CommandTask objects that represent
 * "commands" in the Command pattern and having the DispatchServer (or MultiDispatchServer)
 * use this class as its Server Command lets you implement the Command pattern.
 * @author Karthik Rangaraju
 * @see org.k2d2.serverframework.core.ServerCommand
 */
public class CommandTaskServer extends ServerCommand
{
    /**
     * This method casts the pInObject to a CommandTask object and calls execute() on
     * it. The object returned by CommandTask.execute() is used as this method's return
     * value
     * @see org.k2d2.serverframework.util.CommandTask
     */
    public Object execute(Object pInObject)
    {
        CommandTask command = (CommandTask)pInObject;
        return command.execute();
    }
}

