package org.apache.avalon.excalibur.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/**
 * Fixed length cache with a LRU replacement policy.
 *
 * @author <a href="mailto:colus@isoft.co.kr">Eung-ju Park</a>
 */
public class LruCache
    extends DefaultCache
{
    public LruCache( final int capacity )
    {
        this( new MemoryCacheStore( capacity ) );
    }

    public LruCache( final CacheStore store )
    {
        super( new LruPolicy(), store );
    }
}
