package org.apache.avalon.excalibur.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/**
 * @author <a href="mailto:colus@isoft.co.kr">Eung-ju Park</a>
 */
public class MemoryCacheStore
    extends AbstractCacheStore
{
    private HashMap m_entries;
    private int m_capacity;

    public MemoryCacheStore( final int capacity )
    {
        if ( capacity < 1 ) throw new IllegalArgumentException( "Specified capacity must be at least 1" );

        m_capacity = capacity;
        m_entries = new HashMap( m_capacity );
    }

    public int capacity()
    {
        return m_capacity;
    }

    public int size()
    {
        return m_entries.size();
    }

    public Object get( final Object key )
    {
        return m_entries.get( key );
    }

    public Object put( final Object key, final Object value )
    {
        return m_entries.put( key, value );
    }

    public Object remove( final Object key )
    {
        return m_entries.remove( key );
    }

    public boolean containsKey( final Object key )
    {
        return m_entries.containsKey( key );
    }

    public Iterator list()
    {
        final ArrayList list = new ArrayList();
        list.addAll( m_entries.keySet() );
        return list.iterator();
    }
}
