package com.thinkdynamics.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Helper that knows structure of <code>.classpath</code> file and allows
 * other classes query information about the project.
 * 
 * @author ifedorenko
 */
public class EclipseProject {
    static final String FILENAME = ".classpath";

    private List exports = new ArrayList();
    private URL output;
    private URL workspace;
    private Properties ignoredLibs = new Properties();

    public EclipseProject(URL workspace, URL project) throws EclipseDeploymentException {
        this.workspace = workspace;
        try {
            Document dotClasspath = parseDotClasspath(project);
            parseClasspath(project, dotClasspath);
        } catch (MalformedURLException e) {
            throw new EclipseDeploymentException(e);
        }
        try {
            ignoredLibs.load(getProjectFile(project, ".jboss").openStream());
        } catch (Exception e) {
            //throw new DeploymentException(e);
        }
    }

    public URL getOutputFolder() {
        return output;
    }

    public URL getResource(String name) {
        return new URLClassLoader(new URL[] {output}).getResource(name);
    }

    public Iterator getExportedLibUrls() {
        return exports.iterator();
    }

    public static boolean isProjectURL(URL url) {
        try {
            if (new File(getProjectFile(url, FILENAME).getFile()).canRead()) {
                return true;
            }
        } catch (MalformedURLException ignore) {
        }
        return false;
    }

    //
    //
    //

    private Document parseDotClasspath(URL url) throws EclipseDeploymentException {
        try {
            DocumentBuilder parser =
                    DocumentBuilderFactory.newInstance().newDocumentBuilder();
            //is.setSystemId(docURL.toString());
            Document document = 
                parser.parse(new InputSource(getProjectFile(url, FILENAME).openStream()));
            return document;
        } catch (SAXException e) {
            throw new EclipseDeploymentException(e);
        } catch (ParserConfigurationException e) {
            throw new EclipseDeploymentException(e);
        } catch (IOException e) {
            throw new EclipseDeploymentException(e);
        }
    }

    private void parseClasspath(URL url, Document document) throws MalformedURLException {
        NodeList refs = document.getElementsByTagName("classpathentry");
        for (int i = 0; i < refs.getLength(); i++ ) {
            Element ref = (Element) refs.item(i);
            // @todo apply "replace switch with polymorphism" refactory ;-)
            if ("lib".equals(ref.getAttribute("kind"))
//                    && "true".equals(ref.getAttribute("exported"))
                    && !isIgnoredLib(ref.getAttribute("path"))) {
                exports.add(libUrlFromPath(ref.getAttribute("path")));
            } else if ("src".equals(ref.getAttribute("kind"))
                    && ref.getAttribute("path").startsWith("/")) {
                exports.add(projectUrlFromPath(ref.getAttribute("path")));
            } else if ("output".equals(ref.getAttribute("kind"))) {
                output = outputUrlFromPath(url, ref.getAttribute("path"));
            }
        }
    }

    private boolean isIgnoredLib(String lib) {
        return ignoredLibs.contains(lib);
    }

    private URL outputUrlFromPath(URL project, String output) throws MalformedURLException {
        return new URL(project, output + "/");
    }

    private URL libUrlFromPath(String path) throws MalformedURLException {
        return path.startsWith("/")?
                new URL(workspace, path.substring(1)):
                new URL("file:///" + path);
    }

    private URL projectUrlFromPath(String path) throws MalformedURLException {
        // assume that all projects are inside workspace
        return new URL(workspace, path.substring(1) + "/");
    }

    private static URL getProjectFile(URL url, String filename) throws MalformedURLException {
        return url.toExternalForm().endsWith("/")?
                new URL(url, filename):
                new URL(url.toExternalForm() + "/" + filename);
    }
}
