#ifndef QTRECOMPRESSORCTL_H
#define QTRECOMPRESSORCTL_H
#include "genctl_p.h"
#include "recompressor.h"
#include "qimagecontrol.h"
#include "srcctl.h"
class QtRecompressorCtl : public QtRecompressor
{ 
    Q_OBJECT

public:
    QtRecompressorCtl( QWidget* parent = 0 );
    ~QtRecompressorCtl();

public slots:
    void start_recompress();
    void about_filter_clicked();
    void add_filter_clicked();
    void config_filter_clicked();
    void dest_file_clicked();
    void details_clicked();
    void down_filter_clicked();
    void load_config_clicked();
    void remove_filter_clicked();
    void save_config_clicked();
    void src_file_clicked();
    void src_aud_file_clicked();
    void stream_format_clicked();
    void stream_limit_mode_changed(int);
    void stream_mode_changed(int);
    void stream_selected(int);
    void up_filter_clicked();
    
    void lo_fr_changed(const QString&);
    void hi_fr_changed(const QString&);
    void lo_sec_changed(const QString&);
    void hi_sec_changed(const QString&);
protected:
    void updateFilters();    
    RecKernel* kernel;
    int no_recurs;
    SourceControlWnd* wnd;    
    QImageControl* ictl;
};

#endif // QTRECOMPRESSORCTL_H
