#include <dlfcn.h>

#include <stdlib.h>
#include <stdio.h>

typedef int (*test_function)( const char *file );


int main( int argc, char **argv )
{
 const char *error;
 void *module;
 test_function testavi;

        if( argc != 2 )
        {
                printf( "Usage: %s file.avi\n\n", argv[0] );
                return -1;
        }

 /* Load dynamically loaded library */
 module = dlopen("libtest.so.0.0", RTLD_LAZY);
 if (!module) {
   fprintf(stderr, "Couldn't open libtest.so.0.0: %s\n",
           dlerror());
   exit(1);
 }

 /* Get symbol */
 dlerror();
 testavi = dlsym( module, "testavi");
 if ((error = dlerror())) {
   fprintf(stderr, "Couldn't find testavi: %s\n", error);
   exit(1);
 }

 /* Now call the function in the DL library */
 (*testavi)( argv[1] );

 /* All done, close things cleanly */
 dlclose(module);
 return 0;
}
