#include <stdio.h>
#include <avifile/avifile.h>

extern "C" int testavi( const char *file );

int testavi( const char *file )
{
	IAviReadFile *avi;
	IAviReadStream *stream;

	avi = CreateIAviReadFile( file );
	if( !avi || !avi->IsOpened( ) || !avi->IsValid( ))
	{
		printf( "error opening file %s", file );
		return -1;
	}
	printf( "Video streams: %d\n", avi->VideoStreamCount( ));
	printf( "Audio streams: %d\n", avi->AudioStreamCount( ));

	stream = avi->GetStream( 0, AviStream::Video );
	if( !stream )
	{
		printf( "no video stream detected\n" );
		delete avi;
		return -1;
	}
	if( stream->StartStreaming( ) != 0 )
	{
		printf( "could not start streaming\n" );
		stream->StopStreaming( );
		delete avi;
		return -1;
	}

	printf( "\n\nsuccess !\n" );
	stream->StopStreaming( );
	delete avi;

	return 0;
}
