/***********************************************************
 *
 *	fusesm16.h - Fuse and lock bit definitions for the ATmega16
 *
 *  Copyright 2006-2007 Steven Michalske
 *	Author - Steven Michalske
 *	Modifications - Rick Altherr
 *
 ***********************************************************/

#ifndef __FUSESM16_H__
#define __FUSESM16_H__

/* High Fuse Byte */
#define HFUSE const unsigned char hfuse __attribute__((section (".hfuse")))

#define BOOTRST	~_BV(0)
#define BOOTSZ0	~_BV(1)
#define BOOTSZ1	~_BV(2)
#define EESAVE	~_BV(3)
#define CKOPT	~_BV(4)
#define SPIEN	~_BV(5)
#define JTAGEN	~_BV(6)
#define OCDEN	~_BV(7)

#define HFUSE_DEFAULT JTAGEN & SPIEN & BOOTSZ1 & BOOTSZ0


/* Low Fuse Byte */
#define LFUSE const unsigned char lfuse __attribute__((section (".lfuse")))

#define CKSEL0	 ~_BV(0)
#define CKSEL1	 ~_BV(1)
#define CKSEL2	 ~_BV(2)
#define CKSEL3	 ~_BV(3)
#define SUT0	 ~_BV(4)
#define SUT1	 ~_BV(5)
#define BODEN	 ~_BV(6)
#define BODLEVEL ~_BV(7)

#define LFUSE_DEFUALT SUT0 & CKSEL3 & CKSEL2 & CKSEL1

/* Lock Byte */
#define LOCK const unsigned char lock __attribute__((section (".lock")))

#define LB1		~_BV(0)
#define LB2		~_BV(1)
#define BLB01	~_BV(2)
#define BLB02	~_BV(3)
#define BLB11	~_BV(4)
#define BLB12	~_BV(5)
/* bits 6 and 7 reservered */

/* Convience defines for locking modes */
#define LBM1	LB1 | LB2
#define LBM2	LB2
#define LBM3	0

#define BLB0M1 	BLB02 | BLB01
#define BLB0M2 	BLB02
#define BLB0M3 	0
#define BLB0M4 	BLB01

#define BLB1M1 	BLB12 | BLB11
#define BLB1M2 	BLB12
#define BLB1M3 	0
#define BLB1M4 	BLB11

#define LOCK_DEFAULT 0xFF

#endif /* __FUSESM16_H__ */
