/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain count copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef AXIS2_HTTP_TRANSPORT_H
#define AXIS2_HTTP_TRANSPORT_H

#include <axis2.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * @defgroup axis2_core_transport_http Core HTTP Transport
 * @ingroup axis2_core_transport_http
 * @{
 */

    /** 
    * \brief HTTP protocol and message context constants.
    *
    */
    
    /**
     * CARRIAGE RETURN AND LINE FEED
     */
    #define AXIS2_HTTP_CRLF "\r\n"
    /**
     * PROTOCOL_VERSION
     */
    #define AXIS2_HTTP_PROTOCOL_VERSION "PROTOCOL"
    
    /**
     * REQUEST_URI
     */
    #define AXIS2_HTTP_REQUEST_URI "REQUEST_URI"
    
    /**
     * RESPONSE_CODE
     */
    #define AXIS2_HTTP_RESPONSE_CODE "RESPONSE_CODE"
    
    /**
     * RESPONSE_WORD
     */
    #define AXIS2_HTTP_RESPONSE_WORD "RESPONSE_WORD"
    
    /**
     * RESPONSE_ACK_CODE_VAL
     */
    #define AXIS2_HTTP_RESPONSE_ACK_CODE_VAL "202"
    
    /**
     * SOCKET
     */
    #define AXIS2_SOCKET "SOCKET"
    
    /**
     * HEADER_PROTOCOL_10
     */
    #define AXIS2_HTTP_HEADER_PROTOCOL_10 "HTTP/1.0"
    
    /**
     * HEADER_PROTOCOL_11
     */
    #define AXIS2_HTTP_HEADER_PROTOCOL_11 "HTTP/1.1"
    
    /**
     * CHAR_SET_ENCODING
     */
    #define AXIS2_HTTP_CHAR_SET_ENCODING "charset"
    
    /**
     * HEADER_POST
     */
    #define AXIS2_HTTP_HEADER_POST  "POST"
    
    /**
     * HEADER_GET
     */
    #define AXIS2_HTTP_HEADER_GET "GET"
    
    /**
     * HEADER_HOST
     */
    #define AXIS2_HTTP_HEADER_HOST "Host"
    
    /**
     * HEADER_CONTENT_DESCRIPTION
     */
    #define AXIS2_HTP_HEADER_CONTENT_DESCRIPTION "Content-Description"
    
    /**
     * HEADER_CONTENT_TYPE
     */
    #define AXIS2_HTTP_HEADER_CONTENT_TYPE "Content-Type"
    
    /**
     * HEADER_CONTENT_TRANSFER_ENCODING
     */
    #define AXIS2_HTTP_HEADER_CONTENT_TRANSFER_ENCODING \
                                    "Content-Transfer-Encoding"
    
    /**
     * HEADER_CONTENT_LENGTH
     */
    #define AXIS2_HTTP_HEADER_CONTENT_LENGTH "Content-Length"
    
    /**
     * HEADER_CONTENT_LOCATION
     */
    #define AXIS2_HTTP_HEADER_CONTENT_LOCATION "Content-Location"
    
    /**
     * HEADER_CONTENT_ID
     */
    #define AXIS2_HTTP_HEADER_CONTENT_ID "Content-Id"
    
    /**
     * HEADER_SOAP_ACTION
     */
    #define AXIS2_HTTP_HEADER_SOAP_ACTION "SOAPAction"
    
    /**
     * HEADER_AUTHORIZATION
     */
    #define AXIS2_HTTP_HEADER_AUTHORIZATION "Authorization"
    
    /**
     * HEADER_PROXY_AUTHORIZATION
     */
    #define AXIS2_HTTP_HEADER_PROXY_AUTHORIZATION "Proxy-Authorization"
    
    /**
     * HEADER_EXPECT
     */
    #define AXIS2_HTTP_HEADER_EXPECT "Expect"
    
    /**
     * HEADER_EXPECT_100_Continue
     */
    #define AXIS2_HTTP_HEADER_EXPECT_100_CONTINUE "100-continue"
    
    /**
     * HEADER_USER_AGENT
     */
    #define AXIS2_HTTP_HEADER_USER_AGENT "User-Agent"
    
    /**
     * HEADER_CACHE_CONTROL
     */
    #define AXIS2_HTTP_HEADER_CACHE_CONTROL "Cache-Control"
    
    /**
     * HEADER_CACHE_CONTROL_NOCACHE
     */
    #define AXIS2_HTTP_HEADER_CACHE_CONTROL_NOCACHE "no-cache"
    
    /**
     * HEADER_PRAGMA
     */
    #define AXIS2_HTTP_HEADER_PRAGMA "Pragma"
    
    /**
     * HEADER_LOCATION
     */
    #define AXIS2_HTTP_HEADER_LOCATION "Location"
    
    /**
     * REQUEST_HEADERS
     */
    #define AXIS2_HTTP_REQUEST_HEADERS "HTTP-Request-Headers"
    
    /**
     * RESPONSE_HEADERS
     */
    #define AXIS2_HTTP_RESPONSE_HEADERS "HTTP-Response-Headers"
    
    /* http 1.1 */
    
    /**
     * HEADER_TRANSFER_ENCODING
     */
    #define AXIS2_HTTP_HEADER_TRANSFER_ENCODING "Transfer-Encoding"
    
    /**
     * HEADER_TRANSFER_ENCODING_CHUNKED
     */
    #define AXIS2_HTTP_HEADER_TRANSFER_ENCODING_CHUNKED "chunked"
    
    /**
     * HEADER_CONNECTION
     */
    #define AXIS2_HTTP_HEADER_CONNECTION "Connection"
    
    /**
     * HEADER_CONNECTION_CLOSE
     */
    #define AXIS2_HTTP_HEADER_CONNECTION_CLOSE "close"
    
    /**
     * HEADER_CONNECTION_KEEPALIVE
     */
    #define AXIS2_HTTP_HEADER_CONNECTION_KEEPALIVE "Keep-Alive"
    
    /**
     * HEADER_ACCEPT
     */
    #define AXIS2_HTTP_HEADER_ACCEPT "Accept"
    
    /**
     * HEADER_ACCEPT_TEXT_ALL
     */
    #define AXIS2_HTTP_HEADER_ACCEPT_TEXT_ALL "text/*"
    
    /**
     * HEADER_ACCEPT_TEXT_ALL
     */
    #define AXIS2_HTTP_HEADER_ACCEPT_TEXT_PLAIN "text/plain"
    
    /**
     * HEADER_ACCEPT_APPL_SOAP
     */
    #define AXIS2_HTTP_HEADER_ACCEPT_APPL_SOAP "application/soap+xml"
    
    /**
     * HEADER_ACCEPT_MULTIPART_RELATED
     */
    #define AXIS2_HTTP_HEADER_ACCEPT_MULTIPART_RELATED "multipart/related"
    
    /**
     * HEADER_ACCEPT_APPLICATION_DIME
     */
    #define AXIS2_HTTP_HEADER_ACCEPT_APPLICATION_DIME "application/dime"
    
    /**
     * Cookie headers
    */
    #define AXIS2_HTTP_HEADER_COOKIE "Cookie"
    
    /**
    * HEADER_COOKIE2
    */
    #define AXIS2_HTTP_HEADER_COOKIE2 "Cookie2"
    
    /**
    * HEADER_SET_COOKIE
    */
    #define AXIS2_HTTP_HEADER_SET_COOKIE "Set-Cookie"
    
    /**
    * HEADER_SET_COOKIE2
     */
    #define AXIS2_HTTP_HEADER_SET_COOKIE2 "Set-Cookie2"
    
    /**
     * HTTP header field values
     */
    #define AXIS2_HTTP_HEADER_DEFAULT_CHAR_ENCODING "iso-8859-1"
    
    /**
     * REPONSE_HTTP_OK
     */
    #define AXIS2_HTTP_RESPONSE_OK "200 OK"
    
    /**
     * RESPONSE_HTTP_NOCONTENT
     */
    #define AXIS2_HTTP_RESPONSE_NOCONTENT "202 OK";
    
    /**
     * RESPONSE_HTTP_UNAUTHORIZED
     */
    #define AXIS2_HTTP_RESPONSE_HTTP_UNAUTHORIZED "401 Unauthorized"
    
    /**
     * RESPONSE_BAD_REQUEST
     */
    #define AXIS2_HTTP_RESPONSE_BAD_REQUEST "400 Bad Request"
    
    /**
     * RESPONSE_HTTP_INTERNAL_SERVER_ERROR
     */
    #define AXIS2_HTTP_RESPONSE_INTERNAL_SERVER_ERROR "500 Internal server error"
    
    /**
     * HTTP_REQ_TYPE
     */
    #define AXIS2_HTTP_REQ_TYPE "HTTP_REQ_TYPE"
    
    /**
     * SO_TIMEOUT
     */
    #define AXIS2_HTTP_SO_TIMEOUT "SO_TIMEOUT"
    
    /**
     * CONNECTION_TIMEOUT
     */
    #define AXIS2_HTTP_CONNECTION_TIMEOUT "CONNECTION_TIMEOUT"
    
    /**
     * DEFAULT_SO_TIMEOUT
     */
    #define AXIS2_HTTP_DEFAULT_SO_TIMEOUT 60000
    
    /**
     * DEFAULT_CONNECTION_TIMEOUT
     */
    #define AXIS2_HTTP_DEFAULT_CONNECTION_TIMEOUT 60000
    
    #define AXIS2_HTTP_PROXY "PROXY"
    
    /**
     * ISO-8859-1 encoding
     */
    #define AXIS2_HTTP_ISO_8859_1 "ISO-8859-1"
    /** 
     * Default charset in content
     */
    #define AXIS2_HTTP_DEFAULT_CONTENT_CHARSET "ISO-8859-1"
    
/** @} */
    
#ifdef __cplusplus
}
#endif  
#endif                          /* AXIS2_HTTP_TRANSPORT_H */
