package Apache2::TomKit::Provider::RDBMS;

use strict;

use Apache2::RequestIO;
use Apache2::Const;
use Apache2::TomKit::Util;

use base qw( Apache2::TomKit::IProvider );


sub new {
	my $class  = shift;
	my $logger = shift;
	my $config = shift;
	
	my $this = { config => $config, logger => $logger };
	
	bless $this, $class;
	
	$this->init();
	
	return $this;
}

sub init {
	my $this    = shift;
	my $apr     = $this->{config}->{apr};
	my $adapter = $apr->dir_config( "RDBMSCacheAdapter" );

    if( ! defined $adapter ) {
        $adapter = "Apache2::TomKit::Provider::RDBMS::DBCacheAdapter::SQLite";
    }


    my $content_provider = $apr->dir_config( "RDBMSContentProvider" );

    if( ! defined $content_provider ) {
        $content_provider = "Apache2::TomKit::Provider::RDBMS::ContentProvider::SQL";
    }

    &Apache2::TomKit::Util::loadModule( $adapter );
    &Apache2::TomKit::Util::loadModule( $content_provider );

    $this->{cacheAdapter}   = $adapter->new( $apr );
    $this->{contentAdapter} = $content_provider->new( $apr );
}


sub instanceHandler {
	my $this = shift;
	my $apr  = shift;
	
	$apr->print( $this->{contentAdapter}->getContent() );
	
	return Apache2::Const::OK;
}

sub getMTime {
	return $_[0]->{cacheAdapter}->getMTime();	
}

sub createsDom {
	return 0;
}

1;