package Apache2::TomKit::Cache::FileSystem;

use strict;

use base qw( Apache2::TomKit::Cache::AbstractCache );

sub new {
	my $class      = shift;
	my $logger     = shift;
	my $config     = shift;
#	my $keyBuilder = shift;
	
	my $this = $class->SUPER::new($logger,$config);
	
	my $key      = $this->{keyBuilder}->buildKey();
	my $cacheDir = $this->{config}->getCacheDir();

	if ( ! defined $cacheDir ) {
		$cacheDir = File::Spec->tmpdir();
	}
	
	if( ! -e "$cacheDir/axkit" ) {
		mkdir "$cacheDir/axkit";
	}
	
	$this->{key}       = $key;
	$this->{cachefile} = "$cacheDir/axkit";
	
	#my $this = bless {
	#	logger => $logger,
	#	config => $config,
	#	key    => $key,
	#	cachefile => "$cacheDir/axkit"
	#}, $class;
	
	$this->{logger}->debug( 9, "Setting up the cache with Filesystem" );
	
	return $this;
}

sub deliverFromCacheImpl {
	my $this           = shift;
	my $mtime          = shift;
	my $processorChain = shift;
	
	my $keyBuilder = new Apache2::TomKit::Cache::DefaultKeyBuilder( $this->{logger}, $this->{config} );
	my $key = $keyBuilder->buildKey();
	
	my $rv = new Apache2::TomKit::Cache::Entry( $this->{logger}, $key, $this, $processorChain );
	my $useCached = 1;
	
	if( -e $this->{cachefile} . "/$key" ) {
		my $docTime = (stat($this->{cachefile} . "/$key/content"))[9];
		
		if ( $mtime < $docTime ) {
			my $i = 0;
			
			open( PROCESSORS, "<" . $this->{cachefile} . "/$key/processors" );
				my $time;
				my @loadtimes;
				my @processorDefs;
				
				while( my $processor = <PROCESSORS> ) {
					my @tmp = split("#",$processor);
					push @loadtimes, shift @tmp;
					push @processorDefs, (join "=>",@tmp);
				}
			close( PROCESSORS );
			
			&Apache2::TomKit::Cache::AbstractCache::setUpProcessor($processorChain,$this->{logger},$this->{config},@processorDefs);
			
			foreach( @{ $processorChain->{chain} } ) {
				if( shift @loadtimes > $_->getMTime() ) {
					$useCached = 1;
				} else {
					$useCached = 0;
				}
				
				last if ! $useCached;
			}
			
			if ($useCached) {
				$this->{logger}->debug( 7, "We can use the cached file" );
				$rv->{isCached} = 1;
				local $/ = undef;
				open(CONTENT,"<" . $this->{cachefile} . "/$key/content");
					$rv->{content}  = <CONTENT>;
				close(CONTENT);
			} else {
				$this->{logger}->debug( 7, "One of the processor must have changed. We can not use the cached content" );
			}
		} else {
			$this->{logger}->debug( 7, "The file timestamp is newer than the one of the last delivery. We need to recreate everything." );
			&Apache2::TomKit::Cache::AbstractCache::setUpProcessor($processorChain,$this->{logger},$this->{config},$this->{config}->getProcessorDefs());
		}
	} else {
		$this->{logger}->debug( 7, "No cache found. Set up everything from scratch!" );
		&Apache2::TomKit::Cache::AbstractCache::setUpProcessor($processorChain,$this->{logger},$this->{config},$this->{config}->getProcessorDefs());
	}
		
	return $rv;
}

sub restore {
	my $this       = shift;
	my $cacheEntry = shift;

	$this->{logger}->debug( 9, "Restoring the content in the cache for later retrevial" );
	
	## TODO not 100% => should be mtime of created directory
	my $time = time;
	
	if ( ! $cacheEntry->{isNew} ) {
		$this->{logger}->debug( 9, "Erasing old content");
		unlink $this->{cachefile} . "/" . $cacheEntry->{key};
	}
	
	mkdir $this->{cachefile} . "/". $cacheEntry->{key};
	
	open( CONTENT, ">".$this->{cachefile} . "/". $cacheEntry->{key} . "/content" );
		print CONTENT $cacheEntry->{content};
	close(CONTENT);
	
	open( PROCESSORS, ">" . $this->{cachefile} . "/". $cacheEntry->{key} . "/processors" );
		foreach ( @{ $cacheEntry->{processorChain}->{chain} } ) {
			$this->{logger}->debug( 9, "Restoring processor for document-id (".$cacheEntry->{key}."): " . $_->getKey()  );
			print PROCESSORS $time . "#" . $_->getMappingType() . "#" . $_->getProcessorDefinitionFile();
		}
	close( PROCESSORS );
}

1;