package Apache2::TomKit::Config::DefaultConfig;

use strict;

our $AUTOLOAD;

our %Config = (
    AxNoCache    => 0
);

sub new {
    my $class = shift;
    my $apr   = shift;

    my $this = { apr => $apr, config => $apr->dir_config() };

    bless $this, $class;
}

sub getProcessorDefs {
    my $this = shift;
    my @processors = $this->{config}->get("AxAddProcessorDef");
    
    return @processors;
}

sub getProcessorsMap {
    my $this = shift;
    my @processorsMap = $this->{config}->get("AxAddProcessorMap");
    
    return @processorsMap;
}

sub AUTOLOAD {
    my $this = shift;
    my ($methodName) = $AUTOLOAD =~ /get(\w+)$/;
    $methodName = "Ax$methodName";
    
    my $configValue = $this->{config}->{$methodName};

    if( ! defined $configValue ) {
       $configValue = $Config{$methodName}; 
    }
 
    return $configValue;
}

1;
