package Apache2::TomKit::Processor::LibXSLT;

use XML::LibXML;
use XML::LibXSLT;
use Digest::MD5 qw(md5_hex);
use strict;

sub new {
    my $class          = shift;
    my $logger         = shift;
    my $config         = shift;
    my $processordef   = shift;
    my $getMappingType = shift;
    
    bless { 
            logger         => $logger, 
            config         => $config, 
            processordef   => $processordef, 
            stylesheet     => undef,
            key            => md5_hex($processordef),
            getMappingType => $getMappingType
          }, $class;
}

sub setUp {
    my $this = shift;
    
    return if( $this->{stylesheet} );
    
    my $parser   = new XML::LibXML(); 
    my $xslt = XML::LibXSLT->new();
    my $style_doc = $parser->parse_file( $this->{processordef} );
    my $stylesheet = $xslt->parse_stylesheet($style_doc);

    $this->{stylesheet} = $stylesheet;
}

sub process {
    my $this = shift;
    my $input = shift;
    
    $this->{logger}->debug(9,"LibXSLT: Is processing the source with stylesheet: " . $this->{processordef} );
    
    return $this->{stylesheet}->transform( $input );
}

sub getMTime {
    my $this = shift;
    return (stat($this->{processordef}))[9];
}

sub createsXML {
    1;
}

sub getKey {
	return $_[0]->{key};
}

sub createsDom {
    1;
}

sub getContentType {
    return "text/html";
}

sub getMappingType {
	return $_[0]->{getMappingType}
}

sub getProcessorDefinitionFile {
	return $_[0]->{processordef};
}

1;