package Apache2::TomKit;

use strict;

use Apache2::RequestRec;
use Apache2::RequestUtil;
use Apache2::Request;
use Apache2::Filter;
use Apache2::Const;

use Apache2::TomKit::TomKitEngine;
use Apache2::TomKit::Config::DefaultConfig;
use Apache2::TomKit::Cache::DefaultKeyBuilder;
use Apache2::TomKit::Logging;
use Apache2::TomKit::Cache::SQLite;
use Apache2::TomKit::Cache::FileSystem;
use Apache2::TomKit::Util;
use Apache2::TomKit::ProcessorChain;
use Apache2::TomKit::Cache::AbstractCache;

sub handler {
    my $r = shift;
    my $apr = new Apache2::Request($r);
#	my $apr = $r;
    
    my $config = new Apache2::TomKit::Config::DefaultConfig( $apr );
    my $logging = new Apache2::TomKit::Logging( $config );
    
    $logging->debug(9,"We are handling the source.");

	my $chain = new Apache2::TomKit::ProcessorChain( $logging, $config );
	$config->{apr}->pnotes( "AxProcessorChain" => $chain );
    #&setUpProcessorChain($chain,$logging,$config);
    
    if( $config->getNoCache() == 1 ) {
    	&Apache2::TomKit::Cache::AbstractCache::setUpProcessor($chain,$logging,$config,$config->getProcessorDefs());
        &startUpAxKit($logging,$config);
    } else {
    	my $cache      = new Apache2::TomKit::Cache::FileSystem($logging, $config);
    	my $cacheEntry = $cache->deliverFromCache( $chain );
    	
    	#my $cacheEntry = &Apache2::TomKit::Cache::AbstractCache::deliverFromCache( $chain, $logging, $config );
    	$config->{apr}->pnotes( "AxCacheEntry" => $cacheEntry );
    	$config->{apr}->pnotes( "AxCache"      => $cache      );
    	
        if( ! defined $cacheEntry || ! $cacheEntry->{isCached} ) {
            $logging->debug(9,"Well delivering from cache was not possible. We need to start AxKit");
            &startUpAxKit( $logging, $config );
        } else {
        	$logging->debug(9,"We can deliver the content from the cache.");
        	## TODO maybe we could refactor this to use the object it self as the handler so we would not need to use pnotes
        	$apr->handler('perl-script');
        	$apr->set_handlers( "PerlResponseHandler" => \&Apache2::TomKit::Cache::Entry::handler );
        }
    }
    
    return Apache2::Const::OK;
}


sub startUpAxKit {
	my $logging = shift;
	my $config  = shift;
	
    $logging->debug(9,"We are about to set up full axkit-power");
    
    my $apr = $config->{apr};
    
    ## TODO maybe we could use the object directly as the output filter => so there would be no need to pass things using pnotes
    $apr->add_output_filter( \&Apache2::TomKit::TomKitEngine::handler );
    $apr->pnotes( "AxKitConfig"  => $config  );
    $apr->pnotes( "AxKitLogging" => $logging );
    
    $logging->debug(9,"We added the Output-Filter");
}

1;