package Apache2::TomKit::Cache::DefaultKeyBuilder;

use strict;
use Digest::MD5 qw( md5_hex );
use Apache2::RequestRec;

sub new {
    my $class  = shift;
    my $logger = shift;
    my $config = shift;
    
    bless { logger => $logger, config => $config }, $class;
}

sub buildKey {
    my $this = shift;
    my $host = $this->{config}->{apr}->hostname();
    my $uri  = $this->{config}->{apr}->uri();
    
    my $md5 = md5_hex( $host . $uri );
    
    $this->{logger}->debug(9,"The key: " . $host . $uri . " => " . $md5 );
    
    return $md5;
}

1;
