package Apache2::TomKit::Cache::Entry;

use strict;
use Apache2::RequestRec;
use Apache2::Request;
use Apache2::Const;
use Apache2::RequestIO;

sub new {
	my $class          = shift;
	my $logger         = shift;
	my $key            = shift;
	my $cache          = shift;
	my $processorChain = shift;
	
	bless { logger => $logger, key => $key, isCached => 0, content => undef, cache => $cache, processorChain => $processorChain, isNew => 1 };
}

sub handler {
	my $r = shift;
	
	my $entry = $r->pnotes( "AxCacheEntry" );
	
	$entry->{logger}->debug(9,"Delivering cached content.");
	$r->print( $entry->{content} );
	
	if( defined $entry->{processorChain}->{chain} && scalar @{ $entry->{processorChain}->{chain} } > 0 ) {
		$r->content_type($entry->{processorChain}->{chain}->[-1]->getContentType());
	}
	
	
	return Apache2::Const::OK;
}

sub restore {
	my $this = shift;
	my $content = shift;
	
	$this->{content} = $content;
	$this->{cache}->restore($this);
}

return 1;