#!/bin/sh

if mysql $* -f <<END-OF-DATA

DROP DATABASE IF EXISTS bacula_test2;
CREATE DATABASE bacula_test2;

use bacula_test2;

CREATE TABLE File_test2 (
   FileId INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
   FileIndex INTEGER UNSIGNED DEFAULT 0,
   JobId INTEGER UNSIGNED NOT NULL REFERENCES Job,
   PathId INTEGER UNSIGNED NOT NULL REFERENCES Path,
   FilenameId INTEGER UNSIGNED NOT NULL REFERENCES Filename,
   MarkId INTEGER UNSIGNED DEFAULT 0,
   LStat TINYBLOB NOT NULL,
   MD5 TINYBLOB,

	size INTEGER DEFAULT 0,
	ctime TIMESTAMP,
	mtime TIMESTAMP,

   PRIMARY KEY(FileId),
   INDEX (JobId),
   INDEX (JobId, PathId, FilenameId)
   );

CREATE TABLE Filename_test2 (
  FilenameId INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  Name BLOB NOT NULL,
  PRIMARY KEY(FilenameId),
  INDEX (Name(255))
  );

CREATE TABLE Path_test2 (
   PathId INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
   Path BLOB NOT NULL,
   PRIMARY KEY(PathId),
   INDEX (Path(255))
   );

END-OF-DATA
then
   echo "Creation of test database succeeded."
else
   echo "Creation of test database failed."
fi
exit 0
