/*
 * =====================================================================================
 *
 *       Filename:  fill_file.c
 *
 *    Description: test for bacula. Standart DB structure.
 *
 *        Version:  1.0
 *        Created:  08.10.2008 20:40:18
 *       Compiler:  gcc
 *
 *         Author:  Yuri Timofeev (), tim4dev@gmail.com
 *
 * =====================================================================================
 */

#include "fill_file.h"

int main (int argc, char *argv[])
{
   MYSQL *db;
   MYSQL_RES *res;
   MYSQL_ROW row;

   int  count_records = 1000000; /* set me !!! */
   char *server   = "localhost"; /* set me !!! */
   char *user     = "root";      /* set me !!! */
   char *password = "";          /* set me !!! */
   char *database = "bacula_test";
   char sql[2048];
	char *lstat = "MI s9MB IG0 B H2 H0 A 9t BAA I BIVsDs BIR93m BIVqaC A A E";
	char *md = "nhfRrx3kRqxYuM0R17EQAQ";
	int i;
	char rtxt[2048];
	clock_t start_clock, end_clock;
	time_t start_time, end_time; 
	char *Name = "";
	char *Path = "";

   db = mysql_init(NULL);

   /* Connect to database */
   if (!mysql_real_connect(db, server, user, password, database, 0, NULL, 0)) {
      msgerr(mysql_error(db));
      exit(EXIT_FAILURE);
   }

   printf("Date: %s %s\n", __DATE__, __TIME__);
   printf("Host: %s\nUse database: '%s'.\n", mysql_get_host_info(db), database);

	/* cats/mysql.c:209 Set connection timeout to 8 days specialy for batch mode */
   mysql_query(db, "SET wait_timeout=691200");
   mysql_query(db, "SET interactive_timeout=691200");

   mysql_query(db, "DROP TABLE Path_tmp");
   mysql_query(db, "DROP TABLE Filename_tmp");

	/* cats/sql_create.c:693 */
   if (mysql_query(db, "CREATE TEMPORARY TABLE batch ("
		"FileIndex integer,"
      "JobId integer,"
      "Path blob,"
      "Name blob,"
      "LStat tinyblob,"
      "MD5 tinyblob)")) 
	{
		msgerr(mysql_error(db));
      exit(EXIT_FAILURE);
	};
	
	printf("Temporary table 'batch' created.\n");

	srand(time(0));
   printf("Start filling tables 'batch'(temporary), 'Path', 'Filename' ...\n");
	start_clock = clock();
	start_time = time(NULL);
	for (i=0; i<count_records; i++) {
		Name = rand_str(rtxt, 127);
		Path = rand_str(rtxt, 256);
		/* insert to batch */
		sprintf(sql, "INSERT INTO batch (FileIndex, JobId, Path, Name, LStat, MD5) VALUES (%u, 1, '%s', '%s', '%s', '%s')", 
			i, Path, Name, lstat, md);
		if (mysql_query(db, sql)) {
			msgerr(mysql_error(db));
			exit(EXIT_FAILURE);
		}
		/* insert to Path */
      sprintf(sql, "INSERT INTO Path_test (Path) VALUES ('%s')", Path);
      if (mysql_query(db, sql)) {
         msgerr(mysql_error(db));
         exit(EXIT_FAILURE);
      }
		/* insert to Filename */
      sprintf(sql, "INSERT INTO Filename_test (Name) VALUES ('%s')", Name);
      if (mysql_query(db, sql)) {
         msgerr(mysql_error(db));
         exit(EXIT_FAILURE);
      }

	}
   printf("End.\n%u records inserts.\n",  count_records);
	end_clock = clock();
	end_time = time(NULL);
	prn_elapsedt(start_clock, end_clock, start_time, end_time);

   printf("Start inserts from temporary table 'batch' to 'File' ...\n");
	start_clock = clock();
	start_time = time(NULL); 
	if (mysql_query(db, "INSERT INTO File_test (FileIndex, JobId, PathId, FilenameId, LStat, MD5) "
         "SELECT batch.FileIndex, batch.JobId, Path_test.PathId, "
         "Filename_test.FilenameId,batch.LStat, batch.MD5 "
         "FROM batch "
         "JOIN Path_test ON (batch.Path = Path_test.Path) "
         "JOIN Filename_test ON (batch.Name = Filename_test.Name)"))
	{
		msgerr(mysql_error(db));
      exit(EXIT_FAILURE);
	}
   printf("End inserts to 'File' ...\n");
	end_clock = clock();
	end_time = time(NULL);
	prn_elapsedt(start_clock, end_clock, start_time, end_time);

	/* close connection */
   mysql_close(db);
   exit(EXIT_SUCCESS);
}
	
