/*
 * Created on Apr 1, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.globalcircle;

import java.awt.Component;
import java.awt.geom.Dimension2D;
import java.awt.LayoutManager;

import org.w3c.dom.svg.SVGDocument;

import org.apache.batik.bridge.*;
import org.apache.batik.swing.gvt.*;
import org.apache.batik.swing.svg.*;

/**
 * @author bibek
 *
 * Interface which must be supported by any component which is to be used with 
 * a SVGLayoutManager.  Note that JSVGComponent already supports all of these 
 * except getBridgeContext() [which is trivial to implement].
 */
public interface ISVGLayoutComponent {
	
	/** returns the LayoutManager used to arrange child components */
	public LayoutManager getLayout();
	
	/** returns the number of child components */
	public int getComponentCount();
	
	/** returns the child component at index <code>index</code> */
	public Component getComponent(int index);
	
	/** returns the current BridgeContext for the component */
	public BridgeContext getBridgeContext();
	
	/** returns the SVGDocument in which elements should be searched for */
	public SVGDocument getSVGDocument();

	/** returns the size (in pixels) of the active SVGDocument */
	public Dimension2D getSVGDocumentSize();

	/** adds a GVTTreeBuilderListener to the component */
	public void addGVTTreeBuilderListener(GVTTreeBuilderListener listener);
	
	/** removes a GVTTreeBuilderListener from the component */
	public void removeGVTTreeBuilderListener(GVTTreeBuilderListener listener);
	
	/** adds a GVTTreeRendererListener to the component */
	public void addGVTTreeRendererListener(GVTTreeRendererListener listener);

	/** removes a GVTTreeRendererListener from the component */
	public void removeGVTTreeRendererListener(GVTTreeRendererListener listener);
	
	/** adds an UpdateManagerListener to the component */
	public void addUpdateManagerListener(UpdateManagerListener listener);

	/** removes an UpdateManagerListener from the component */
	public void removeUpdateManagerListener(UpdateManagerListener listener);
}
