/*
 * Created on Mar 31, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.globalcircle;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.JSVGComponent;

/**
 * @author bibek
 *
 * Trivial extension of JSVGComponent to provide public access to the
 * BridgeContext.  Also sets the default LayoutManager to be SVGLayoutManager3. 
 */
public class JSVGPanel extends JSVGComponent implements ISVGLayoutComponent {
	
	public JSVGPanel() {
		super();
		setLayout(new SVGLayoutManager());
	}
	
	public BridgeContext getBridgeContext() { return bridgeContext; }
	
	public static void main(String[] args) {
		final JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		final JSVGPanel panel = new JSVGPanel();
//		panel.setDocumentState(JSVGPanel.ALWAYS_STATIC);
		
		JButton saveButton = new JButton("Save");
		saveButton.setOpaque(false);
		saveButton.setBorder(null);
		panel.add(saveButton, "save_button");
		
		JScrollPane sp = new JScrollPane(new JTextArea());
		sp.setBorder(BorderFactory.createTitledBorder("text area"));
		panel.add(sp, "Text_Entry");
		
		panel.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter() {
			public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
//				System.out.println("GVT Build Complete.");
				frame.pack();
			}
		});
		
//		panel.addGVTTreeRendererListener(new GVTTreeRendererListener() {
//			public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
//				System.out.println("gvtRenderingCancelled...");
//			}
//			
//			public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
//				System.out.println("gvtRenderingCompleted...");
//				frame.setVisible(true);
//			}
//			
//			public void gvtRenderingFailed(GVTTreeRendererEvent e) {
//				System.out.println("gvtRenderingFailed...");
//			}
//			
//			public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
//				System.out.println("gvtRenderingPrepare...");
//			}
//			
//			public void gvtRenderingStarted(GVTTreeRendererEvent e) {
//				System.out.println("gvtRenderingStarted...");
//			}
//			
//		});
//		
//		panel.addUpdateManagerListener(new UpdateManagerListener() {
//			public void managerResumed(UpdateManagerEvent e) {
//				System.out.println("managerResumed: e=" + e);
//			}
//			
//			public void managerStarted(UpdateManagerEvent e) {
//				System.out.println("managerStarted: e=" + e);
//			}
//			
//			public void managerStopped(UpdateManagerEvent e) {
//				System.out.println("managerStopped: e=" + e);
//			}
//			
//			public void managerSuspended(UpdateManagerEvent e) {
//				System.out.println("managerSuspended: e=" + e);
//			}
//			
//			public void updateCompleted(UpdateManagerEvent e) {
//				System.out.println("updateCompleted: e=" + e);
//			}
//			
//			public void updateFailed(UpdateManagerEvent e) {
//				System.out.println("updateFailed: e=" + e);
//			}
//			
//			public void updateStarted(UpdateManagerEvent e) {
//				System.out.println("updateStarted: e=" + e);
//			}
//		});
		
		frame.getContentPane().add(panel);
		
		panel.loadSVGDocument("file:MyGUI.svg");
		
		frame.setVisible(true);
	}
}
