package org.globalcircle;

// no package

//~ import org.apache.batik.bridge.FocusManager;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.swing.gvt.InteractorAdapter;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

import org.apache.batik.gvt.*;
import org.apache.batik.swing.*;
import org.apache.batik.swing.gvt.*;
import org.apache.batik.swing.svg.*;

import org.w3c.dom.svg.*;
import org.w3c.dom.*;

/** Debugging methods for various SVG methods. */
public class SVGDebug
{
	/// no instance of this class is needed
    /** An instance of SVGDebug */    
	protected SVGDebug() {}
	
        /** print info about the Element 'elem'
         * @param prefix The prefix of the element.
         * @param elem The element that information is being retrieved about.
         */        
	public static void printElementInfo(String prefix, Element elem)
	{
		if(elem == null)
			return;
		
		if(prefix == null)
			prefix = "";
		
		println(prefix + "id=" + elem.getAttribute("id"));
		
		if(elem instanceof SVGElement)
		{
			SVGElement svgElem = (SVGElement)elem;
			SVGSVGElement owner = svgElem.getOwnerSVGElement();
			
			if(owner != null)
			{
				printSVGLength(prefix + "owner x: ", owner.getX());
				printSVGLength(prefix + "owner y: ", owner.getY());
				printSVGLength(prefix + "owner width: ", owner.getWidth());
				printSVGLength(prefix + "owner height: ", owner.getHeight());
				//~ printSVGRect(prefix + "owner-viewport-rect ", owner.getViewport());
			}
			
			if(svgElem instanceof SVGLocatable)
			{
				printSVGRect(prefix + "locatable-bbox ",((SVGLocatable)svgElem).getBBox());
			}
			
			printElementInfo(prefix + "viewport:", svgElem.getViewportElement());
		}
	}
	
        /** print an SVGRect
         * @param prefix The prefix of the rect.
         * @param rect The rect element that is being printed.
         */        
	public static void printSVGRect(String prefix, SVGRect rect)
	{
		println(prefix + "x: " + rect.getX());
		println(prefix + "y: " + rect.getY());
		println(prefix + "width: " + rect.getWidth());
		println(prefix + "height: " + rect.getHeight());
	}
	
        /** print the base value of a SVGAnimatedLength
         * @param prefix The preFix of the SVGAnimatedLength
         * @param l The length of the SVGAnimatedLength
         */        
	public static void printSVGLength(String prefix, SVGAnimatedLength l)
	{
		printSVGLength(prefix, l.getBaseVal());
	}

        /** print a SVGLength
         * @param prefix The prefix of the SVGLength.
         * @param l The length of the SVGLength object.
         */        
	public static void printSVGLength(String prefix, SVGLength l)
	{
		println(prefix + l.getValue());
	}
	
        /** print a SVGMatrix
         * @param prefix The prefix of the SVGMatrix.
         * @param m The SVGMatrix to be printed out.
         */        
	public static void printSVGMatrix(String prefix, SVGMatrix m)
	{
		println(prefix + "["
			+ "[" + m.getA() + "," + m.getC() + "," + m.getE() + "] "
			+ "[" + m.getB() + "," + m.getD() + "," + m.getF() + "]"
			+"]");
	}
	
        /** set the values of a SVGMatrix 'm' to the matrix values contained in 'newValues'
         * @param m The SVGMatrix whos values are to be changed.
         * @param newValues The new values for the SVGMatrix.
         */        
	public static void setMatrixValues(SVGMatrix m, SVGMatrix newValues)
	{
		m.setA( newValues.getA() );
		m.setB( newValues.getB() );
		m.setC( newValues.getC() );
		m.setD( newValues.getD() );
		m.setE( newValues.getE() );
		m.setF( newValues.getF() );
	}
//        
//        public void traceElement(Element elem) { traceElement(elem, 0); }
//        
//        public void traceElement(Element elem, int depth) {
//            depthString(depth);
//            System.out.println(depthString(depth) + "traceElement: elem = " + elem + " (node id=" + elem.getAttributeNS(null, "id") + ")");
//            
//            NodeList nodeList = elem.getChildNodes();
//            int numChildNodes = nodeList.getLength();
//            Node node;
//            for(int i=0; i < numChildNodes; ++i) {
//                node = nodeList.item(i);
//                if(node instanceof Element)
//                    traceElement((Element) node, depth+1);
//            }
//        }
    
    /** Indents a line of text appropriatly.
     * @param depth The size of the indent
     * @return The new line of text after being indented
     */    
    public static String depthString(int depth)
    {
        StringBuffer sb = new StringBuffer(depth);
        for(int i=0; i < depth; i++)
            sb.append("  ");

        return sb.toString();
    }
    
    /** Traces the path of the graphics node.
     * @param gn The graphics node to be traced.
     */    
    public static void traceGraphicsNode(GraphicsNode gn) { traceGraphicsNode(gn, 0); }

    /** prints out the graphics node tree.
     * @param gn The graphics node to start from.
     * @param depth How far into the graphics tree to print out.
     */    
    public static void traceGraphicsNode(GraphicsNode gn, int depth)
    {
        // print info about gn
        System.out.println(depthString(depth) + "gn=" + gn);

        if(gn instanceof CompositeGraphicsNode)
        {
            CompositeGraphicsNode cgn = (CompositeGraphicsNode) gn;
            for(Iterator it=cgn.getChildren().iterator(); it.hasNext(); )
            {
                traceGraphicsNode((GraphicsNode) it.next(), depth+1);
            }
        }
    }
	
        /** prints a debug message
         * @param message The debug message to print.
         */        
	public static void println(String message)
	{
		System.out.println(message);
	}
}
