/*
 * Created on Mar 28, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.globalcircle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;

import java.util.WeakHashMap;

import org.w3c.dom.Element;

import org.apache.batik.bridge.*;
import org.apache.batik.gvt.*;
import org.apache.batik.swing.gvt.*;

/**
 * @author bibek
 *
 * A LayoutManager designed to sit atop a ISVGLayoutComponent, which allows one to
 * add child components which will be automatically arranged to lay on top of 
 * SVG Elements.
 * 
 * If you have the SVG:
 *   &lt;svg ...&gt;
 *     &lt;rect id="open_button_id" x="10" y="10" width="10" height="10" /&gt;
 *     &lt;rect id="save_button_id" x="30" y="10" width="10" height="10" /&gt;
 *   &lt;/svg&gt;
 *
 * then you can add JButtons which will be placed on top of the two rects using:
 * 
 *   ISVGLayoutComponent svgComp = ...;
 * 	 svgComp.setLayout(new SVGLayoutManager());
 *   svgComp.loadSVGDocument("file:myGUI.svg");
 * 	 svgComp.add(new JButton("open"), "open_button_id");
 * 	 svgComp.add(new JButton("save"), "save_button_id");
 * 
 * As the window is scaled/resized/etc., the SVG will be automatically scaled
 * to fit (by Batik), and the two <code>JButton</code>s will be moved and 
 * scaled (by this layout manager) so that they remain exactly on top of the
 * two <code>SVGRectElement</code>s.
 */
public class SVGLayoutManager implements LayoutManager2 {
	
	private final static Dimension EMPTY_SIZE = new Dimension(0, 0);
	private final static Dimension MAXIMUM_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
	
	private WeakHashMap childIDMap = new WeakHashMap();
	private static WeakHashMap watchedContainers = new WeakHashMap();

	private void addListeners(final ISVGLayoutComponent panel)
	{
		panel.addUpdateManagerListener(new UpdateManagerAdapter() {
			public void updateStarted(UpdateManagerEvent e) {
//				System.out.println("addListeners$UpdateManagerListener: updateStarted()");
				
				if(panel.getLayout() != SVGLayoutManager.this)
					panel.removeUpdateManagerListener(this);
				else
					arrangeComponents(panel); //panel.doLayout();
			}
		});
		
		panel.addGVTTreeRendererListener(new GVTTreeRendererAdapter() {
			public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
//				System.out.println("addListeners$GVTTreeRendererListener: gvtRenderingCompleted()");
				
				if(panel.getLayout() != SVGLayoutManager.this)
					panel.removeGVTTreeRendererListener(this);
				else
					arrangeComponents(panel); //panel.doLayout();
			}
		});
		
		watchedContainers.put(panel, null);
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager2#getLayoutAlignmentX(java.awt.Container)
	 */
	public float getLayoutAlignmentX(Container arg0) {
		// TODO Auto-generated method stub
		System.out.println("getLayoutAlignmentX");
		return 0;
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager2#getLayoutAlignmentY(java.awt.Container)
	 */
	public float getLayoutAlignmentY(Container arg0) {
		// TODO Auto-generated method stub
		System.out.println("getLayoutAlignmentY");
		return 0;
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager2#invalidateLayout(java.awt.Container)
	 */
	public void invalidateLayout(Container arg0) {
//		System.out.println("invalidateLayout");
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager2#maximumLayoutSize(java.awt.Container)
	 */
	public Dimension maximumLayoutSize(Container arg0) {
//		System.out.println("maximumLayoutSize");
		return MAXIMUM_SIZE;
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager2#addLayoutComponent(java.awt.Component, java.lang.Object)
	 */
	public void addLayoutComponent(Component component, Object constraints) {
//		System.out.println("addLayoutComponent");
		childIDMap.put(component, constraints);
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#removeLayoutComponent(java.awt.Component)
	 */
	public void removeLayoutComponent(Component component) {
//		System.out.println("removeLayoutComponent");
		childIDMap.remove(component);
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#layoutContainer(java.awt.Container)
	 */
	public void layoutContainer(Container container) {
//		System.out.println("layoutContainer");
		if( ! (container instanceof ISVGLayoutComponent) )
			throw new IllegalArgumentException("SVGLayoutManager may only be used on ISVGLayoutComponent containers.");
		
		if( ! watchedContainers.containsKey(container) )
			addListeners((ISVGLayoutComponent) container);
		
		arrangeComponents((ISVGLayoutComponent) container);
	}
	
	/** lays out the children of the svgComponent */
	public void arrangeComponents(ISVGLayoutComponent svgComponent)
	{
//		System.out.println("arrangeComponents: svgComponent = " + svgComponent);
		
		try {
			if(svgComponent.getSVGDocument() != null)
			{
				for(int i=svgComponent.getComponentCount(); i > 0; --i)
				{
					Component childComponent = svgComponent.getComponent(i-1);
					
					String elementID = (String) childIDMap.get(childComponent);
					
					GraphicsNode gn = null;
					
					Element elem = svgComponent.getSVGDocument().getElementById(elementID);
//					if(elem != null)
//						SVGDebug.printSVGRect("element bounds", ((SVGLocatable)elem).getBBox());
					
					if(svgComponent.getBridgeContext() != null)
						gn = svgComponent.getBridgeContext().getGraphicsNode(elem);
//					System.out.println("layoutContainer: elem=" + elem + "; gn=" + gn);
					
					if(gn != null)
					{
						Rectangle transformedBounds = gn.getGlobalTransform().createTransformedShape(gn.getBounds()).getBounds();
//						System.out.println("layoutContainer: transformedBounds = " + transformedBounds);
						
						if(!transformedBounds.equals(childComponent.getBounds()))
						{
							childComponent.setBounds(transformedBounds);
							childComponent.validate();
						}
					}
	
//					Element elem = svgComponent.getSVGDocument().getElementById(elementID);
//					if(elem != null)
//					{
//						SVGLocatable locatable = (SVGLocatable) elem;
//						SVGRect bounds = locatable.getBBox();
//						if(bounds != null)
//						{
//							childComponent.setBounds(
//									(int)bounds.getX(),
//									(int)bounds.getY(),
//									(int)bounds.getWidth(),
//									(int)bounds.getHeight() );
//						}
//					}
				}
			}
		}
		catch(Exception e) { e.printStackTrace(); }
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#addLayoutComponent(java.lang.String, java.awt.Component)
	 */
	public void addLayoutComponent(String constraints, Component component) {
//		System.out.println("addLayoutComponent");
		childIDMap.put(component, constraints);
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#minimumLayoutSize(java.awt.Container)
	 */
	public Dimension minimumLayoutSize(Container container) {
//		System.out.println("minimumLayoutSize");
		return EMPTY_SIZE;
	}
	
	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#preferredLayoutSize(java.awt.Container)
	 */
	public Dimension preferredLayoutSize(Container container) {
//		System.out.println("preferredLayoutSize");
		ISVGLayoutComponent comp = (ISVGLayoutComponent) container;
		
		Dimension2D size = comp.getSVGDocumentSize();
		if(size != null)
			return new Dimension((int)size.getWidth(), (int)size.getHeight());

		// can't figure out size; return empty-size (0, 0).
		return EMPTY_SIZE;
	}
	
}
