/**
 * $Id$
 */
package vista;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;

import javax.swing.JFrame;

import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.swing.svg.AbstractJSVGComponent;
import org.apache.batik.transcoder.svg2svg.PrettyPrinter;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;


/**
 * @author rvillarreal
 *
 */
public class SVGSimpleTest {

	public static void main( String[] args ) {
		JFrame frame = new JFrame( "Hello SVG world" );
		frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		
		/*
		 * If 'embed' is 'true', it'll put the image in the black
		 * border (and fail).  If set to 'false', it'll put the
		 * external image in and display it correctly.
		 */
		boolean embed = false;
		JSVGCanvas c = new JSVGCanvas();
		c.setLayout( null );
		c.setOpaque( false );
		c.setDoubleBuffered( true );
		c.setDoubleBufferedRendering( true );
		c.setBackground( new Color( 0, 0, 0, 0 ) );
		c.setDocumentState( AbstractJSVGComponent.ALWAYS_DYNAMIC );
		try {
			DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
			String svg = SVGDOMImplementation.SVG_NAMESPACE_URI;
			SVGDocument doc = (SVGDocument) impl.createDocument( svg, "svg", null );
			Element svg_root = doc.getDocumentElement();
			svg_root.setAttributeNS( null, "width", "680" );
			svg_root.setAttributeNS( null, "height", "520" );
		
			Element border = doc.createElementNS( svg, "rect" );
			border.setAttributeNS( null, "x", "0" );
			border.setAttributeNS( null, "y", "0" );
			border.setAttributeNS( null, "width", "680" );
			border.setAttributeNS( null, "height", "520" );
			border.setAttributeNS( null, "style", "opacity:1;fill:none;fill-opacity:1;stroke:#000000;stroke-opacity:1;stroke-width:5" );
			svg_root.appendChild( border );
			c.setDocument( doc );
			
			String parser = XMLResourceDescriptor.getXMLParserClassName();
			SAXSVGDocumentFactory f = new SAXSVGDocumentFactory( parser );
			String uri = new File( "resources/images/svgtest/fixture2.svg" ).toURL().toString();
			SVGDocument kid = f.createSVGDocument( uri );
			if ( embed ) {
				Element svg_root_parent = doc.getDocumentElement();
				Element svg_root_child = kid.getDocumentElement();
				
				NodeList list = svg_root_child.getChildNodes();
				for ( int i = 0; i < list.getLength(); i++ ) {
					Node n = list.item( i );
					if ( n.getNodeType() != Node.ELEMENT_NODE ) {
						continue; }
					n = doc.importNode( n, true );
					svg_root_parent.appendChild( n ); } }
			else {
				doc = kid; }
			printDoc( doc );
			c.setDocument( doc ); }
		catch ( Exception e ) {
			e.printStackTrace(); }
		
		JSVGScrollPane pane = new JSVGScrollPane( c );
		
		frame.setContentPane( pane );
		frame.pack();
		frame.setSize( new Dimension( 1000, 700 ) );
		frame.setVisible( true ); }
	
	public static void printDoc( SVGDocument doc ) {
		PrettyPrinter pp = new PrettyPrinter();
		pp.setFormat( true );
		StringWriter sw = new StringWriter();
		try {
			DOMUtilities.writeDocument( doc, sw ); }
		catch ( Exception e ) {
			e.printStackTrace(); }
		StringReader sr = new StringReader( sw.toString() );
		try {
			sw = new StringWriter();
			pp.print( sr, sw ); }
		catch ( Exception e ) {
			e.printStackTrace(); }
		System.out.println( sw.toString() ); }
}
