(module client
  (extern (socket-shutdown/read::unspecified (::obj) "socket_shutdown_read")
          (socket-shutdown/write::unspecified (::obj) "socket_shutdown_write")
          (socket-shutdown/read-write::unspecified (::obj) "socket_shutdown_read_write"))
  (main main))

(define (call-server host port request-str)
  (let* ((s (make-client-socket host port))
         (pin (socket-input s))
         (pout (socket-output s)))
    (display request-str pout)
    (flush-output-port pout)
    (socket-shutdown/write s)
    (call-with-output-string
      (lambda (result)
        (let loop ((c (read-char pin)))
          (cond ((eof-object? c)
                 (socket-close s))
                (else
	         (write-char c result)
                 (loop (read-char pin)))))))))

(define (main argv)
  (display (call-server "localhost" 12345 "hello world")))
