#if defined( _MSC_VER) || defined( _MINGW_VER )
#  define _BGL_WIN32_VER
#endif

#include <stddef.h>
#include <bigloo_config.h>
#include <time.h>
#ifndef _BGL_WIN32_VER
#   include <sys/types.h> 
#   include <sys/socket.h>
#   include <netinet/in.h>
#   include <arpa/inet.h>
#   include <netdb.h>
#   ifdef BGL_ANDROID
#     include <linux/in.h>
#     if( !defined( INET_ADDRSTRLEN ) )
         /* INET_ADDRSTRLEN seems to be missing up to r8b */
#        define INET_ADDRSTRLEN 16
#     endif
#   endif
#   if( BGL_HAVE_SELECT )
#     include <sys/time.h>
#     include <unistd.h>
#   endif
#else
#   if defined( _MINGW_VER )
#      include "windows.h"
#   endif
#   include <winsock2.h>
#   include <mswsock.h>
#   include <ws2tcpip.h>
#   include <io.h>
#endif
#include <fcntl.h>
#include <memory.h>
#include <errno.h>
#include <bigloo.h>

#ifndef _BGL_WIN32_VER
#   define BAD_SOCKET(s) ((s) < 0)
#else
#   define BAD_SOCKET(s) ((s) == INVALID_SOCKET)
#endif

#if !BGL_HAVE_SOCKLEN
typedef int socklen_t;
#endif

#if( BGL_HAVE_SOCKET_TCP_NODELAY \
     || BGL_HAVE_SOCKET_TCP_CORK \
     || BGL_HAVE_SOCKET_TCP_QUICKACK )
#   include <sys/socket.h>
#   include <netinet/in.h>
#   include <netinet/tcp.h>
#endif

#if( BGL_HAVE_UNIX_SOCKET )
#   include <sys/un.h>
#endif

#if( BGL_HAVE_GETIFADDRS )
#   include <arpa/inet.h>
#   include <ifaddrs.h>
#endif

#if( BGL_HAVE_GETHWADDRS )
#  include <sys/ioctl.h>
#  include <net/if.h>
#endif

#if( !defined( IFF_LOOPBACK ) )
#  define IFF_LOOPBACK 0
#endif

#if( !defined( SHUT_RD ) )
#  define SHUT_RD 0
#endif   
#if( !defined( SHUT_WR ) )
#  define SHUT_WR 1
#endif   
#if( !defined( SHUT_RDWR ) )
#  define SHUT_RDWR 2
#endif   

/*---------------------------------------------------------------------*/
/*    imports ...                                                      */
/*---------------------------------------------------------------------*/
extern obj_t bgl_close_input_port( obj_t );
extern obj_t bgl_close_output_port( obj_t );

/*---------------------------------------------------------------------*/
/*    socket mutex                                                     */
/*---------------------------------------------------------------------*/
static obj_t socket_mutex = BUNSPEC;

/*---------------------------------------------------------------------*/
/*    static void                                                      */
/*    socket_error ...                                                 */
/*---------------------------------------------------------------------*/
static void
socket_error( const char *who, const char *message, obj_t object ) {
   C_SYSTEM_FAILURE( BGL_IO_ERROR, (char *)who, (char *)message, object );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    socket_shutdown and friends (.._read, .._write, .._read_write)   */
/*---------------------------------------------------------------------*/

BGL_RUNTIME_DEF obj_t
socket_shutdown( obj_t sock, int how ) {
    int fd = SOCKET( sock ).fd;

    if( fd > 0 ) {
        if( shutdown( fd, how ) ) {
            char *buffer = alloca( 1024 );
            BGL_MUTEX_LOCK( socket_mutex );
            sprintf( buffer, "cannot shutdown socket (how = %d), %s %d", how, strerror( errno ), fd );
            BGL_MUTEX_UNLOCK( socket_mutex );
            socket_error( "socket-shutdown", buffer, sock );
        }
    }
    
    if( ( how == SHUT_RD ) || ( how == SHUT_RDWR ) ) {
        if( INPUT_PORTP( SOCKET( sock ).input ) ) {
	    bgl_close_input_port( SOCKET( sock ).input );
	}
    }

    if( ( how == SHUT_WR ) || ( how == SHUT_RDWR ) ) {
        if( OUTPUT_PORTP( SOCKET( sock ).output ) ) {
	    bgl_close_output_port( SOCKET( sock ).output );
	}
    }
    
    return BUNSPEC;
}

BGL_RUNTIME_DEF obj_t
socket_shutdown_read( obj_t sock ) {
    return socket_shutdown( sock, SHUT_RD );
}
BGL_RUNTIME_DEF obj_t
socket_shutdown_write( obj_t sock ) {
    return socket_shutdown( sock , SHUT_WR );
}
BGL_RUNTIME_DEF obj_t
socket_shutdown_read_write( obj_t sock ) {
    return socket_shutdown( sock, SHUT_RDWR );
}
