(module server
  (extern (socket-shutdown/read::unspecified (::obj) "socket_shutdown_read")
          (socket-shutdown/write::unspecified (::obj) "socket_shutdown_write")
	  (socket-shutdown/read-write::unspecified (::obj) "socket_shutdown_read_write"))
  (main main))

(define (byte-count-server port)
  (let* ((s (make-server-socket port))
         (s2 (socket-accept s :inbuf #f)))
    (let ((pin (socket-input s2))
          (pout (socket-output s2)))
      (let loop ((count 0)
                 (c (read-char pin)))
        (cond ((eof-object? c)
               (write count pout)
               (flush-output-port pout)
               (socket-shutdown/write s2)
               (socket-close s2))
              (else
               (loop (+ count 1)
                     (read-char pin))))))
    (socket-close s)))

(define (main argv)
  (byte-count-server 12345))
