# From pkgsrc

######################################################################
# shquote arg
#       Returns a backslashed and quoted version of arg in $shquoted.
######################################################################
shquote()
{
        : ${echo=echo}
        : ${sed=sed}

        _shq_arg=$1
        _shq_sed="$sed -e 1s/^X//"
        _shq_sed_quote_subst='s/\([\`\"$\\]\)/\\\1/g'
        case $_shq_arg in
        *[\`\"\$\\]*)
                shquoted=`$echo "X$_shq_arg" | $_shq_sed -e "$_shq_sed_quote_subst"`
                ;;
        *)
                shquoted="$_shq_arg"
                ;;
        esac
        case $shquoted in
        *[\[\~\#\^\&\*\(\)\{\}\|\;\<\>\?\'\ \	]*|*]*|"")
                shquoted="\"$shquoted\""
                ;;
        esac
}

