
      /* confdefs.h.  */
#define PACKAGE_NAME ""
#define PACKAGE_TARNAME ""
#define PACKAGE_VERSION ""
#define PACKAGE_STRING ""
#define PACKAGE_BUGREPORT ""
#define PACKAGE "libsigsegv"
#define VERSION "2.6"
#define STDC_HEADERS 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_SYS_STAT_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STRING_H 1
#define HAVE_MEMORY_H 1
#define HAVE_STRINGS_H 1
#define HAVE_INTTYPES_H 1
#define HAVE_STDINT_H 1
#define HAVE_UNISTD_H 1
#define HAVE_DLFCN_H 1
#define LT_OBJDIR ".libs/"
#define HAVE_SYS_SIGNAL_H 1
#define CFG_SIGNALS "signals.h"
#define HAVE_UNISTD_H 1
#define HAVE_GETPAGESIZE 1
#define HAVE_SYSCONF_PAGESIZE 1
#define HAVE_MMAP_ANON 1
#define HAVE_MMAP_ANONYMOUS 1
#define HAVE_MMAP_DEVZERO 1
#define CFG_FAULT "fault-posix.h"
#define CFG_MACHFAULT "fault-none.h"
#define STACK_DIRECTION -1
#define HAVE_MINCORE 1
#define HAVE_STACKVMA 1
#define CFG_STACKVMA "stackvma-linux.c"
#define HAVE_GETRLIMIT 1
#define HAVE_SETRLIMIT 1
#define HAVE_SIGALTSTACK 1
#define HAVE_WORKING_SIGALTSTACK 1
/* end confdefs.h.  */

#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

#ifndef SS_ONSTACK
#define SS_ONSTACK SA_ONSTACK
#endif

#if HAVE_SETRLIMIT
# include <sys/types.h>
# include <sys/time.h>
# include <sys/resource.h>
#endif
#ifndef SIGSTKSZ
# define SIGSTKSZ 16384
#endif
jmp_buf mainloop;
sigset_t mainsigset;
int pass = 0;
void stackoverflow_handler (int sig)
{
  pass++;
  sigprocmask (SIG_SETMASK, &mainsigset, NULL);
  { stack_t ss;
   if (sigaltstack (NULL, &ss) >= 0)
     {
       ss.ss_flags &= ~SS_ONSTACK;
       sigaltstack (&ss, NULL);
     }
   }
  longjmp (mainloop, pass);
}
volatile int * recurse_1 (volatile int n, volatile int *p)
{
  if (n >= 0)
    *recurse_1 (n + 1, p) += n;
  return p;
}
int recurse (volatile int n)
{
  int sum = 0;
  return *recurse_1 (n, &sum);
}
int main ()
{
  char mystack[SIGSTKSZ];
  stack_t altstack;
  struct sigaction action;
  sigset_t emptyset;
#if defined HAVE_SETRLIMIT && defined RLIMIT_STACK
  /* Before starting the endless recursion, try to be friendly to the user's
     machine.  On some Linux 2.2.x systems, there is no stack limit for user
     processes at all.  We don't want to kill such systems.  */
  struct rlimit rl;
  rl.rlim_cur = rl.rlim_max = 0x100000; /* 1 MB */
  setrlimit (RLIMIT_STACK, &rl);
#endif
  /* Install the alternate stack.  */
  altstack.ss_sp = mystack;
  altstack.ss_size = sizeof (mystack);
  altstack.ss_flags = 0; /* no SS_DISABLE */
  if (sigaltstack (&altstack, NULL) < 0)
    exit (1);
  /* Install the SIGSEGV handler.  */
  sigemptyset (&action.sa_mask);
  action.sa_handler = &stackoverflow_handler;
  action.sa_flags = SA_ONSTACK;
  sigaction (SIGSEGV, &action, (struct sigaction *) NULL);
  sigaction (SIGBUS, &action, (struct sigaction *) NULL);
  /* Save the current signal mask.  */
  sigemptyset (&emptyset);
  sigprocmask (SIG_BLOCK, &emptyset, &mainsigset);
  /* Provoke two stack overflows in a row.  */
  if (setjmp (mainloop) < 2)
    {
      recurse (0);
      exit (2);
    }
  exit (0);
}
