#!/bin/bash
echo "$0: $- : $$">&2;
if [ x != x"${BASH_LOADABLES_DIR}" ]; then
if ! enable | egrep -q killpg; then
   enable -f ${BASH_LOADABLES_DIR}/killpg killpg ||
   { echo "unable to enable killpg loadable built-in - please set BASH_LOADABLES_DIR to directory containing it." >&2;
     exit 1;      
   }
fi
declare -i JOB_PID=0;
function quit ()
{
    declare -i s=$?;
    declare -i sig='(s>128)?s-128:0';
    trap '' HUP INT QUIT TERM EXIT;
    if (( JOB_PID > 0 )); then
       if killpg $JOB_PID; then
          echo 'killpg '${JOB_PID}' OK.' >&2;
          ((JOB_PID=0));
       fi
       wait;
    fi
    trap '' EXIT;
    exit $s;
}
trap 'quit' INT HUP QUIT TERM EXIT;
else
    echo 'Demonstrating the bug. Please kill the nterm.sh process manually.' >&2;
fi
./job.sh </dev/null &
JOB_PID="$!";
echo "JOB: $JOB_PID";
declare -i ts="$(date '+%s')" te=0;
while true; do
  sleep 1;
  te="$(date '+%s')"
  if (( ( te - ts ) >= ${TIMEOUT:-8} )); then
      echo "$0: timeout - killing job: $JOB_PID" >&2;
      if [ z != z"$BASH_LOADABLES_DIR" ]; then
         killpg $JOB_PID;
      else
         kill -HUP $JOB_PID;
      fi
      wait;
      ((JOB_PID=0));      
      break;
  fi
done
echo "$0: $$: exiting.";
