#!/bin/bash
declare -a pstat=($(cat /proc/$$/stat));
declare -i pgid="${pstat[4]}";
echo "$0: $$: pgid : $pgid" >&2
trap 's=$?;echo "$0: $$: exits $s" >&2; trap "" EXIT; exit $s;' INT HUP QUIT TERM EXIT
if [ x != x${BASH_LOADABLES_DIR} ]; then
   if ! enable | egrep -q setpgid; then
      enable -f ${BASH_LOADABLES_DIR}/setpgid setpgid ||
      { echo "unable to enable setpgid loadable built-in - "\
             "please set BASH_LOADABLES_DIR to directory containing it." >&2;
        exit 1;        
      }
   fi
   setpgid || { echo "setpgid failed"; exit 1; };
   pstat=($(cat /proc/$$/stat));
   pgid="${pstat[4]}";
   echo "$0: $$: pgid now : $pgid" >&2
else
   echo "job.sh will be killed, but nterm.sh will not.">&2;
fi;
./nterm.sh






