/* setpgid.c: bash loadable wrapper for setpgid system call:
 */
#include <config.h>

#if defined (HAVE_UNISTD_H)
#  include <unistd.h>
#endif
#include <errno.h>
#include <string.h>

#include "bashtypes.h"
#include "posixtime.h"

#include <stdio.h>

#include "builtins.h"
#include "shell.h"
#include "common.h"

#include "bashgetopt.h"

int
setpgid_builtin
( WORD_LIST *list )
{
  register WORD_LIST *word=list;
  intmax_t pid_arg, pgid_arg;
  pid_t pid=0, pgid=0;
  if( word != NULL )
  {
    if( (word->word != NULL)
      &&(word->word->word != NULL)
      )
    {
      if( ! legal_number( word->word->word, &pid_arg ) )
      {
         builtin_error("First 'pid' argument must be numeric.");         
         return (EXECUTION_FAILURE);
      }
      if( pid_arg < 0 )
      {
         builtin_error("negative 'pid' values not allowed.");         
         return (EXECUTION_FAILURE);
      }
      pid = pid_arg;
      word=word->next;
      if( (word->word != NULL)
        &&(word->word->word != NULL)
        )
      {
        if( ! legal_number( word->word->word, &pgid_arg ) )
        {
          builtin_error("Second 'pgid' argument must be numeric.");         
          return (EXECUTION_FAILURE);
        }
        if( pgid_arg < 0 )
        {
          builtin_error("negative 'pgid' values not allowed.");
          return (EXECUTION_FAILURE);
        }
      }
      pgid = pgid_arg;
    }
  }
  errno = 0;
  if( setpgid(pid, pgid) != 0 )
  {
    builtin_error("failed: %s",strerror(errno));
    return (EXECUTION_FAILURE);     
  }
  return (EXECUTION_SUCCESS);     
}

const char *setpgid_doc[]=
{ "setpgid: invoke the setpgid(2) system call"
, ""
, "Arguments:"
, "   #1: pid : numeric process identifer, >= 0"
, "   #2: pgid: numeric process group identifier, >=0"
, "See the setpgid(2) manual page."
, ((const char *)0)
};

struct builtin setpgid_struct =
{ "setpgid"
, setpgid_builtin
, BUILTIN_ENABLED
, (char **)setpgid_doc
, "setpgid <pid> <pgid>"  
, 0
};
