#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

static int mypid = 0;

static void catch_sigint(int signo) {
    fprintf(stderr, "nap (%d): signal INT caught.\n", mypid);
    exit(1);
}
 
static void catch_sigterm(int signo) {
    fprintf(stderr, "nap (%d): signal TERM caught.\n", mypid);
    exit(1);
}
 
int main(void) {
    mypid = ( int )getpid();

    if (signal(SIGINT, catch_sigint) == SIG_ERR) {
        fputs("An error occurred while setting a signal handler.\n", stderr);
        return EXIT_FAILURE;
    }
    if (signal(SIGTERM, catch_sigterm) == SIG_ERR) {
        fputs("An error occurred while setting a signal handler.\n", stderr);
        return EXIT_FAILURE;
    }
    fprintf(stderr, "nap: running as process %d.\n", mypid);
    sleep(10);
    puts("nap: wake up.");
    return EXIT_SUCCESS;
}
