#!/bin/bash

set -mb
shopt -s nullglob extglob dotglob globstar lastpipe expand_aliases

unset ye1
me=$( realpath "$BASH_SOURCE" ) medir=${me%/*} states=~/.xbl-states PATH=$PATH:$medir/bin mein=$PWD \
supported='/@(eval[12]|bin|set|shopt|declare|function|alias|pc|runtime)/*' \
xblpp=${xblp+cat${ye1=}}${ye1-.}

[[ ! -d $states ]] && mkdir -p "$states"

[[ -v xblpe ]] && eval -- "$xblpe"

for arg in "$medir" "$@"; do
 [[ ! -e $arg ]] && continue

 rarg=$( realpath "$arg" 2>&- ) || rarg=$arg
 pos=( "$rarg"$supported )

 unset inroot
 [[ -d $rarg/root ]] && {
  inroot=$rarg/root
  cd "$inroot"
 }

 [[ -d $rarg/bin ]] && PATH=$PATH:$rarg/bin
 [[ -d $rarg/state ]] && states2=$rarg/state || states2=

tt=$states/files.long.$SRANDOM$SRANDOM hash=$(
 cksum < <(
  kopi.gawk "$tt" < <(
   find \
    "${pos[@]}" \
     \( -name '*.off' -o -name '*.old' -o -name '*.old.*' -o -name '*.off.*' -o -name '*.sw[a-z]' \) -prune -o \
     -printf '%Y\0%s\0%m\0%T@\0%f\0%p\0\0'
  )
 )
) t=$states/$hash ttt=$tt.$hash t2=${states2:+$states2/$hash} \

mv -- "$tt" "$ttt"

$xblpp <(
 if [[ -s $t ]] ; then
  cat -- "$t"
 elif [[ -s $t2 ]] ; then
  cat -- "$t2"
 else
  kopi.gawk "$t." < <(
   xbl.gawk < <(
    kopi.gawk "$t.files" < <(
     xbl.files.gawk -v name="$arg" -v base="$rarg" <"$ttt"
    )
   )
  )
  mv -- "$t"{.,}
  mv -- "$ttt" "$t.files.long"
 fi
 true
)

[[ -v inroot ]] && cd "$mein"

done

mkPATH

[[ -v xble ]] && eval -- "$xble"
true
