#!/usr/bin/gawk -f

BEGIN {
 way = ( way == "" ) ? "enc" : way
 stdin = ( stdin == "" ) ? 0 : stdin

 enc_re = "[^a-zA-Z0-9,.@%/_-]"
 dec_re = "%[0-9a-fA-F]{2}|&(0?[xX][0-9a-fA-F]+|[0-9]+);"

 if ( way == "enc" ) {
  encto = ( encto == "" ) ? "h" : "d"
  re = enc_re
 } else if ( way == "dec" )
  re = dec_re

 RS = "\0"
 FS = "<!no!exist!>"
}

function encdec_line( line, rt ) {
 sav_ = sav_ line rt
}

function retencdec( str, id, call, re ) {
 SAV[id] = str
 encdec_process( id, call, re )
 return SAV[id]
}

stdin {
 SAV[1] = SAV[1] $0 RT
}

END {
 if ( stdin ) {
  encdec_process( 1, way, re )
  printf "%s", SAV[1]
  #sav_ = ""
 }
}

function encdec_process( which , call , re , r ) {
 while ( ( r = get( re, SAV[which] ) ) != "" ) @call( r , which )
}

function get( re, s ) {
 return match( s, re ) ? substr( s, RSTART, RLENGTH ) : ""
}

function enc( s , which ) {
 gsub( s, enc_( s ), SAV[which] )
}

function dec( s , which , r ) {
 if ( s ~ /^%/ ) r = substr( s, 2 )
 else if ( s ~ /^&.*;/ ) {
  r = substr( s, 2, length( s ) -2 )
  if ( r ~ /[xX]/ ) sub( /0?[xX]/, "", r )
  else r = sprintf( "%x", r )
 }
 gsub( s, dec_( r ), SAV[which] )
}

function q( s ) {
 return "'" gensub( "'", "'\\''", "g", s ) "'"
}

function cmd( c , rs , rt , srt , ors , r ) {
 if ( rs != "" ) {
  ors = RS
  RS = rs
 }
  
 c | getline r
 close( c )

 if ( rs != "" )
  RS = ors

 return rt ? RT : srt ? r RT : r
}

function enc_( s ) {
 return cmd( "bhenc_p" encto " " q( s ) )
}

function dec_( s ) {
 return cmd( "bhdec_gn " q( s ) )
}