#include <a.h>

int main(void)
{
	fptr *fp;

	/* 
	 * Here we call function(), which initially selects a traditional
	 * abicalls stub
	 */
	function();

	/* We show as this function to give us the address of function(),
	 * however the linker is not aware that the address of function() will
	 * be referenced within the shared object
	 */ 
	set_function_address(&fp);

	/* when we now as this funtion to invoke our function pointer, it does
	 * so from the GOT context of b.so, and thus if it transfer into an
	 * abicalls stub it will load the incorrect got entry (ie that from
	 * b.so rather a) and havoc will ensue!
	 */
	invoke_function(fp);

#if 0
	/* But if this code is enabled, the reference to the address of function()
	 * causes a PLT to be used, and the address of the PLT becomes
	 * the canonical address of function()
	 */
	fp = function;
#endif

	return 0;
}
