#ifndef _AST_H_
#define _AST_H_

#include <stdio.h>
#include <ctype.h>

typedef enum {
	NJoin=1,


	/* Lexical Conventions A.4 */

	NIdentifier,
	/* Expressions A.4 */
	NUnqualified_id,
	NQualified_id,
	NQua_unqualified,
	NQua_id,
	NNested_name_specifier,
	/* Declarations A.6 */
	NDeclaration,
	NSimple_declaration,
	NSimple_type_specifier,
	/* Declarators A.7 */
	NDeclarator_func,
	NDeclarator_id_typename,
	NDeclarator_id,
	NFunction_definition_ctor,

	/* Classes A.8 */
	NClass_name,

	/* others */
	NDos_dos_punts,



	NAmbig, NAmbig_join

} node_t;


int identificador_node_ast;
#define MAX_AST_SONS 4
typedef struct node
{
  node_t             type;
  int		     no_nodes;
  struct node        *parent;
  struct node	     *sons[MAX_AST_SONS];
  int                line;
  char *             text;
  int		     id;
} *AST;

char *type2string (node_t type);
#define ASTLeaf(node,line,text) ASTMake(node,0,0,0,0,line,text)
#define ASTMake1(node,son0,line,text) ASTMake(node,son0,0,0,0,line,text)
#define ASTMake2(node,son0,son1,line,text) ASTMake(node,son0,son1,0,0,line,text)
#define ASTMake3(node,son0,son1,son2,line,text) ASTMake(node,son0,son1,son2,0,line,text)
#define ASTMake4(node,son0,son1,son2,son3,line,text) ASTMake(node,son0,son1,son2,son3,line,text)

AST ASTMake( node_t type, AST son0, AST son1, AST son2, AST son3, int line, char *text);

#define ASTType(a) ((a)->type)
#define ASTParent(a) ((a)->parent)
#define ASTLine(a) ((a)->line)
#define ASTText(a) ((a)->text)
#define ASTSon0(a) ((a)->sons[0])
#define ASTSon1(a) ((a)->sons[1])
#define ASTSon2(a) ((a)->sons[2])
#define ASTSon3(a) ((a)->sons[3])


AST ast_clone_rec(AST tree);
AST ast_clone(AST tree);


#endif
