%{
#include "y.tab.h"

int yywrap();

void parse_token();
void parse_token_text();
int no_line=1;

%}

%option 8bit
%option lex-compat
%option stack






hexdigit        [a-fA-F0-9]
hexquad         {hexdigit}{hexdigit}{hexdigit}{hexdigit}
uchar           (\\u{hexquad}|\\U{hexquad}{hexquad})
nondigit    	([_a-zA-Z]|uchar)
digit		[0-9]



idnondigit	({nondigit}|{uchar})



%%


{idnondigit}({idnondigit}|{digit})* {parse_token_text(); return IDENTIFIER; }

"}"         { return '}'; }
"{"         { return '{'; }
")"         { return ')'; }
"("         { return '('; }

";"			{ return ';'; }
"::"			{ return DOS_DOS_PUNTS; }

[\n] 		{no_line++;}
[ \t\v\f]	{  }
.		{ /* ignore bad characters */ }


%%


int yywrap()
{
	return 1;
}

void parse_token()
{
	yylval.token_atrib.line = no_line;
}

void parse_token_text()
{
	parse_token();
	yylval.token_atrib.text = strdup(yytext);
}
