%{
#define YYDEBUG 1
#define YYERROR_VERBOSE


typedef struct {
	char* text;
	int line;
} type_token_atrib;

int yyerror(char* s);

yydebug = 1;

%}


%union {
	type_token_atrib token_atrib;

	int i;
};


%token<token_atrib> IDENTIFIER 


%token<token_atrib> DOS_DOS_PUNTS 



%type<i> function_definition declarator_id


%debug
 
%glr-parser

%start declaration_seq

%%

identifier
	: IDENTIFIER
	;

/* Expressions */


id_expression
	: identifier
	| qualified_id
	;

qualified_id
	: dos_dos_punts_opt nested_name_specifier identifier
	| dos_dos_punts identifier
	;

nested_name_specifier
	: class_name dos_dos_punts nested_name_specifier_opt
	;

nested_name_specifier_opt
	: /* empty*/
	| nested_name_specifier
	;

/* Declarations */

declaration_seq
	: declaration
	| declaration_seq declaration
	;

/*declaration_seq_opt
	:  /* empty
	| declaration_seq
	;
*/
declaration
	: simple_declaration 
	| function_definition
		{ printf("%d", $1); }
	;

simple_declaration
	: simple_type_specifier direct_declarator ';'
	;

decl_specifier
	: simple_type_specifier
	;

decl_specifier_seq
	: decl_specifier_seq_opt decl_specifier 
	;

decl_specifier_seq_opt
	: /* empty*/
	| decl_specifier_seq
	;

simple_type_specifier
	: dos_dos_punts_opt nested_name_specifier_opt type_name
	;

type_name
	: class_name 
	;


/* Declarators */


direct_declarator
	: declarator_id
		{ printf("%d", $1); }
	| direct_declarator '(' ')' 
	;

declarator_id
	: dos_dos_punts_opt nested_name_specifier_opt type_name %merge <a>
	| id_expression %merge <a>
	;

function_definition
	: decl_specifier_seq_opt direct_declarator '{' '}' %merge <a>
	;



/* Classes */

class_name
	: identifier
	;

/* others */

dos_dos_punts
	: DOS_DOS_PUNTS
	;

dos_dos_punts_opt
	: /* empty*/
	| dos_dos_punts
	;

%%

#include "lex.yy.c"

int yyerror (char* s)
{
	fprintf(stderr, "%s in line %d\n", s, no_line);
	return 0;
}

int a(YYSTYPE f, YYSTYPE s){
	return 0;
}
int main( int argc, char *argv[] )
{
	extern FILE *yyin;
	yyin = fopen( argv[1], "r");

	yyparse();
	printf("Ok, doned\n");
	return(0);
}
