#!/bin/bash

if test -z "$1" || test "$1" = "-h" || test "$1" = "--help"; then
  echo "Usage: relink.sh PATH_TO_BUILD_OF_COREUTILS_HEAD"
  if test -z "$1"; then
    exit 1
  else
    exit 0
  fi
fi
COREUTILS=$1

function check_dir() {
  if test ! -d "$1"; then
    printf "\033[0m\033[01;31mDirectory does not exists:\033[0m\033[m $1\n"
    exit 1
  fi
}
function check_file() {
  if test ! -f "$1"; then
    printf "\033[0m\033[01;31mFile does not exist:\033[0m\033[m $1\n"
    exit 1
  fi
}
check_dir   "$COREUTILS"
CU_LIB="$COREUTILS/lib"
check_dir   "$CU_LIB"
check_file  "$CU_LIB/libcoreutils.a"

CU_LIBVER="$COREUTILS/src/libver.a"
CU_SYSTEM_H="$COREUTILS/src/system.h"
CU_VERSION_H="$COREUTILS/src/version.h"
CU_SORT_C="$COREUTILS/src/sort.c"
check_file  "$CU_LIBVER"
check_file  "$CU_SYSTEM_H"
check_file  "$CU_VERSION_H"
check_file  "$CU_SORT_C"

echo ">>> Linking with $COREUTILS"
fail=0

function link() {
  if test -e "$2"; then
    rm -f "$2" || return 1
  fi
  ln -s "$1" "$2" || return 1
  return 0
}
link "$CU_LIB"        ./lib           || fail=1
link "$CU_LIBVER"     ./src/libver.a  || fail=1
link "$CU_SYSTEM_H"   ./src/system.h  || fail=1
link "$CU_VERSION_H"  ./src/version.h || fail=1
link "$CU_SORT_C"     ./src/sort.c    || fail=1

if test $fail = 0; then
  printf "\033[0m\033[01;32m--- Linking done\033[0m\033[m\n\n"
  printf "You can build sources in 'src' directory using 'make'.\n"
else
  printf "\033[0m\033[01;31m!!! Linking error\033[0m\033[m\n"
fi

exit $fail
