#!/bin/bash
function cmp() {
  printf "\tsort-$1: "
  cat $2 | ./sort-$1 -V > out-$1
  if diff output out-$1 > /dev/null; then
    printf "\t\033[0m\033[01;32mmatch\033[0m\033[m\n"
    rm -f out-$1
  else
    total=`cat output | wc -l`
    diff=`comm output out-$1 -23 | wc -l`
    ratio=`bc <<< "100-(100*$diff/$total)"`
    printf "\t\033[0m\033[01;31mdiffers\033[0m\033[m ($ratio%% match)\n"
    return 1
  fi
}

INPUT=$1
SORT=$2
if test ! -f "$INPUT" || test -z "$SORT"; then
  echo "Usage: check.sh INPUT SORT"
  exit 1
fi

make -j > /dev/null || exit 1
if test ! -x "./$SORT"; then
  printf "\033[0m\033[01;31mNot an executable file:\033[0m\033[m ./$SORT\n"
  exit 1
fi

printf "Generating output of $SORT: "
cat $INPUT | ./$SORT -V > output && printf "ok\n" || exit 1

fail=0
cmp glibc $INPUT          || fail=1
cmp glibc-patched $INPUT  || fail=1
cmp rpm $INPUT            || fail=1
cmp rpm-patched $INPUT    || fail=1
cmp deb $INPUT            || fail=1
cmp deb-patched $INPUT    || fail=1

if test "$fail" = 0; then
  rm -f output
else
  exit 1
fi
